#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#
#                            Class EARLAIPWE                           #
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#
# Results of the Efficient Augmentation and Relaxation learning        #
# using the Augmented Inverse Probability Weighted Estimator           #
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#
# outcome : OutcomeRegression object                                   #
# Inherits from EARLIPWE                                               #
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#
.checkEARLAIPWE <- function(object) {

  errors <- character()

  if( !is(object@outcome, "SingleDecisionPoint") ) {
    msg <- "outcome is not of appropriate class"
    errors <- c(errors, msg)
  }

  if( !is(object@outcome, "SubsetsNotModeled") ) {
    msg <- "outcome is not of appropriate class"
    errors <- c(errors, msg)
  }

  if( length(errors) == 0L ) {
    return(TRUE)
  } else {
    return(errors)
  }
}

setClass(Class = "EARLAIPWE",
         contains = c("EARL", "PropensityAndOutcome"),
         validity = .checkEARLAIPWE)


#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#
#                           EARLAIPWE METHODS                          #
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++#

#----------------------------------------------------------------------#
# Retrieve a string describing the method used to obtain the object    # 
#----------------------------------------------------------------------#
#   params                                                             #
# object : an object of class EARLAIPWE                                #
#   returns                                                            #
# String indicating EARLAIPWE estimator                                #
#----------------------------------------------------------------------#
setMethod(f = "DTRstep", 
          signature = c(object = "EARLAIPWE"), 
          definition = function(object){
                         return("Efficient Augmentation and Relaxation Learning AIPWE")
                       } )

#----------------------------------------------------------------------#
# Print key results.                                                   # 
#----------------------------------------------------------------------#
#   params                                                             #
# x : an object of class EARLAIPWE                                     #
#----------------------------------------------------------------------#
setMethod(f = "print",    
          signature = c(x = "EARLAIPWE"), 
          definition = function(x, ...){
                         cat("\n", DTRstep(x), "\n")
                         print(x = as(x,"EARL"))
                         print(x = as(x,"PropensityAndOutcome"))
                         cat("\nEstimated Value:", estimator(x),"\n\n")

                       } )

#----------------------------------------------------------------------#
# Show the key results.                                                # 
#----------------------------------------------------------------------#
#   params                                                             #
# object : an object of class EARLAIPWE                                #
#----------------------------------------------------------------------#
setMethod(f = "show",    
          signature = c(object = "EARLAIPWE"), 
          definition = function(object){
                         cat("\n", DTRstep(object), "\n")
                         show(object = as(object,"EARL"))
                         show(object = as(object,"PropensityAndOutcome"))
                         cat("\nEstimated Value:", estimator(object),"\n\n")

                       } )

#----------------------------------------------------------------------#
# Retrieve the summary object of the propensity and outcome regressions#
#----------------------------------------------------------------------#
#   params                                                             #
# object : an object of class EARLIPWE                                 #
#   returns                                                            #
# a list with a three elements, 'propensity', holding the summary      #
# of the fit object returned by the propensity regression method.      #
# 'optim' holds the key results of the optimization as defined in      #
# RWLOptim. 'outcome' hold the summary object defined for the          #
# OutcomeRegression object; 'value' is the estimated value             #
#----------------------------------------------------------------------#
setMethod(f = "summary",    
          signature = c(object = "EARLAIPWE"), 
          definition = function(object, ...){
                         result <- summary(object = as(object,"EARL"))
                         result <- c(result, summary(object = as(object,"PropensityAndOutcome")))
                         return(result)
                       } )

