% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelMarkdown.R
\name{autoMLReport}
\alias{autoMLReport}
\title{Display autoMLmodel output in HTML format using Rmarkdown}
\usage{
autoMLReport(mlobject, mldata = NULL, op_file = NULL, op_dir = NULL)
}
\arguments{
\item{mlobject}{[autoMLmodel Object | Required] autoMLmodel function output}

\item{mldata}{[autoDataprep Object | Optional] autoDataprep function output}

\item{op_file}{[character | Required] output file name (.html)}

\item{op_dir}{[character | Optional] output path. Default path is the current working directory}
}
\value{
HTML R Markdown output
}
\description{
This function will generate R markdown report for DriveML model object
}
\details{
Using this function we can easily present the model outcome in standard HTML format without writing Rmarkdown scripts
}
\examples{
## Creating HTML report
\donttest{
 autoMLReport(heart.model, mldata = NULL, op_file = "sample.html", op_dir = tempdir())
 }
}
