% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_reduction.R
\name{network_reduction_by_p_value}
\alias{network_reduction_by_p_value}
\title{[INTERNAL] Reduce the the entries in an adjacency matrix by thresholding on p-values}
\source{
\code{\link[WGCNA]{corPvalueStudent}}
}
\usage{
network_reduction_by_p_value(
  adjacency_matrix,
  number_of_samples,
  p_value_adjustment_method = "BH",
  reduction_alpha = 0.05,
  parallel_chunk_size = 10^6
)
}
\arguments{
\item{adjacency_matrix}{[matrix] Adjacency matrix of correlations computed using \code{\link[WGCNA]{cor}} in
\code{\link[DrDimont]{compute_correlation_matrices}}}

\item{number_of_samples}{[int|matrix] The number of samples used to calculate the correlation matrix. Computed applying
\code{\link[DrDimont]{sample_size}}}

\item{p_value_adjustment_method}{["holm"|"hochberg"|"hommel"|"bonferroni"|"BH"|"BY"|"fdr"|"none"] String
of the correction method applied to p-values. Passed to \link[stats]{p.adjust}. (default: "BH")}

\item{reduction_alpha}{[float] A number indicating the significance value for correlation p-values
during reduction. Not-significant edges are dropped. (default: 0.05)}

\item{parallel_chunk_size}{[int] Number of p-values in smallest work unit when computing in parallel
during network reduction with method `p_value`. (default: 10^6)}
}
\value{
A reduced adjacency matrix with NA's at martix entries with p-values below threshold.
}
\description{
[INTERNAL] This function reduces an adjacency matrix of correlations based on p-values.
If computations are done non-parallel \code{\link[WGCNA]{corPvalueStudent}} is used. If computations
are done in parallel, our own parallel implementation (\code{\link[DrDimont]{corPvalueStudentParallel}})
of this function to calculate Student asymptotic p-values taking the number of samples into account is used.
P-values are adjusted using \link[stats]{p.adjust} function. The upper triangle without diagonal entries
of the adjacency matrix is passed for faster computation. P-values can be adjusted using one
of several methods. A significance threshold `alpha` can be set. All value entries below this threshold within the
initial adjacency matrix will be set to NA. If a default cluster is registered with the `parallel` package the
computation will happen in parallel automatically.
}
