% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelFit.R
\name{modelFit}
\alias{modelFit}
\title{Fit a Bayesian Latent Factor to a data set
using STAN}
\usage{
modelFit(model = "igPLT", prog = "stan", parallel = TRUE, Xhisto = NULL,
  nchains = 4, nthin = 10, niter = 10000, D)
}
\arguments{
\item{model}{a string indicating the type of model ("igPLT", "cauchyPLT" or "igsparse", default = "PLT")}

\item{prog}{a string indicating the MCMC program to use (default = "stan")}

\item{parallel}{true or false, whether or not to parelleize (done using the package "parallel")}

\item{Xhisto}{matrix of simulated data (projected onto the histogram basis)}

\item{nchains}{number of chains (default = 2)}

\item{nthin}{the number of thinned interations (default = 1)}

\item{niter}{number of iterations (default = 1e4)}

\item{D}{number of latent factors}
}
\value{
stanfit, a STAN object
}
\description{
Fit a Bayesian Latent Factor to a data set
using STAN
}
\author{
Gabrielle Weinrott
}
\references{
The Stan Development Team Stan Modeling Language User's Guide and Reference Manual. http://mc-stan.org/
}

