% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Musicnotation.R
\name{musicnotation}
\alias{musicnotation}
\alias{Musicnotation}
\title{Function musicnotation}
\usage{
Musicnotation(data_sheet, ...)
}
\arguments{
\item{data_sheet}{\bold{either} a data.frame f.e imported from a data sheet containing\cr
"Name","item.number"\cr
"action.from.","action.to","kind.of.action"\cr
"name.of.action","action.number","classification","weighting"\cr
\cr
\bold{or} only "action.from.","action.to","kind.of.action"if exists actions and items\cr
\cr
actions: with  "name.of.action","action.number","classification","weighting\cr 
items:  with "Name","item.number"\cr 
Setting a behaviour to 2 means it is count double\cr}

\item{\dots}{\bold{Additional parameters:}
 \describe{
  \item{\bold{colors}}{a factor of colors as much as actions}
  \item{\bold{lwd}}{line width if lwd_arrows is not used also for line width arrows}
# TODO check this it not working -> no show_items all items will be shown
  \item{\bold{show_items}}{items to be shown}
  \item{\bold{angel_arrows}}{The angel aof the arrow head default 20}
  \item{\bold{length_arrows}}{the lenght of the arrow default 0.05}
  \item{\bold{lwd_arrows}}{the line width of the arrows default 1}
  \item{\bold{actions_colors}}{a vector of colors for actions f.e to show one special action}
  \item{\bold{starting_time}}{builds the graph with data bewteen starting and ending time}
  \item{\bold{ending_time}}{builds the graph with data bewteen starting and ending time}
  \item{\bold{user_colors}}{a vector of colors as much as items to show differetn colors for items}
  \item{\bold{color_bits}}{a vector of colors as much as items 1 shows the horse colored 0 in black (defined with actions_colors)}
}}
}
\value{
returns a list with\cr
ADI - the Average Dominance index\cr
}
\description{
A function to visualize interaction wit a musicnotation graph.
}
\examples{
{ #you can eihter use:
data_sheet=data.frame   ("action.from"=c(1,4,2,3,4,3,4,3,4,3,4,3,4,3,4),
                         "action.to"=c(4,1,1,4,3,4,3,4,3,4,3,4,3,4,3),
                         "kind.of.action"= c(4,1,1,4,3,4,3,4,3,4,3,4,3,4,3),
                         "Time"=c('03:15:00','03:17:30','03:20:00','03:20:30','03:21:00',
                                  '03:21:30','03:22:00','03:22:30','03:23:00','03:23:30',
                                  '03:25:00','03:25:30','03:26:00','03:26:30','03:27:00'),
                         stringsAsFactors=FALSE)
items= data.frame ("Name"=c("item1","item2","item3","item4","item5","item6") ,
                   "item.number"=c(1:6),stringsAsFactors=FALSE)
actions=data.frame("name.of.action"= c("leading","following","approach","bite","threat to bite",
                                      "kick","threat to kick", "chase","retreat"),
                  "action.number"=c(1:9),
                  "classification"=c(1,2,1,1,1,1,1,1,2) ,
                  "weighting"=c(1,-1,1,1,1,1,1,1,-1),stringsAsFactors=FALSE)
# set colors for special encounters
color= c("green","green","red","red","red","red","red","red")    

Musicnotation(data_sheet=data_sheet,actions=actions,items=items,sort_dominance=TRUE)
#or you can use a complete f.e Excel sheet
#you can save this data as basic excel sheet to work with
data(data_Musicnotation)
Musicnotation(data_sheet=data_Musicnotation,sort_dominance=TRUE) }
}
\references{
{
#Chase, I. D. (2006). Music notation: a new method for visualizing social interaction in animals and humans. Front Zool, 3, 18. 
\url{http://dx.doi.org/10.1186\%2F1742-9994-3-18}\cr
}
}
\author{
Knut Krueger, \email{Knut.Krueger@equine-science.de}
}
