% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_edge_df.R
\name{add_edge_df}
\alias{add_edge_df}
\title{Add edges from an edge data frame to an existing graph object}
\usage{
add_edge_df(graph, edge_df)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{edge_df}{An edge data frame that is created using \code{\link[=create_edge_df]{create_edge_df()}}.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class \code{dgr_graph}, add edges from an edge data frame
to that graph.
}
\examples{
# Create a graph with 4 nodes
# and no edges
graph <-
  create_graph() \%>\%
  add_n_nodes(n = 4)

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = c(1, 2, 3),
      to = c(4, 3, 1))

# Add the edge data frame to
# the graph object to create
# a graph with both nodes
# and edges
graph <-
  graph \%>\%
  add_edge_df(
    edge_df = edf)

# Get the graph's edges to
# verify that the edf had
# been added
graph \%>\%
  get_edges(
    return_type = "vector")

}
\seealso{
Other Edge creation and removal: 
\code{\link{add_edge_clone}()},
\code{\link{add_edges_from_table}()},
\code{\link{add_edges_w_string}()},
\code{\link{add_edge}()},
\code{\link{add_forward_edges_ws}()},
\code{\link{add_reverse_edges_ws}()},
\code{\link{copy_edge_attrs}()},
\code{\link{create_edge_df}()},
\code{\link{delete_edges_ws}()},
\code{\link{delete_edge}()},
\code{\link{delete_loop_edges_ws}()},
\code{\link{drop_edge_attrs}()},
\code{\link{edge_data}()},
\code{\link{join_edge_attrs}()},
\code{\link{mutate_edge_attrs_ws}()},
\code{\link{mutate_edge_attrs}()},
\code{\link{recode_edge_attrs}()},
\code{\link{rename_edge_attrs}()},
\code{\link{rescale_edge_attrs}()},
\code{\link{rev_edge_dir_ws}()},
\code{\link{rev_edge_dir}()},
\code{\link{set_edge_attr_to_display}()},
\code{\link{set_edge_attrs_ws}()},
\code{\link{set_edge_attrs}()}
}
\concept{Edge creation and removal}
