% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clear_selection.R
\name{clear_selection}
\alias{clear_selection}
\title{Clear an active selection of nodes or edges}
\usage{
clear_selection(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a graph object of class
\code{dgr_graph}.
}
\description{
Clear the selection of
nodes or edges within a graph object.
}
\examples{
# Create a graph with
# a single path
graph <-
  create_graph() \%>\%
  add_path(n = 5)

# Select nodes with IDs `1`
# and `3`
graph <-
  graph \%>\%
  select_nodes(
    nodes = c(1, 3))

# Verify that a node selection
# has been made
graph \%>\%
  get_selection()

# Clear the selection with
# `clear_selection()`
graph <-
  graph \%>\%
  clear_selection()

# Verify that the node
# selection has been cleared
graph \%>\%
  get_selection()
}
