% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_asymmetric_node_pairs.R
\name{count_asymmetric_node_pairs}
\alias{count_asymmetric_node_pairs}
\title{Get the number of asymmetrically-connected node pairs}
\usage{
count_asymmetric_node_pairs(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a single numeric value
representing the number of
asymmetrically-connected node pairs.
}
\description{
Get the number of
asymmetrically-connected node pairs.
This works for directed graphs.
}
\examples{
# Create a cycle graph
graph <-
  create_graph() \%>\%
  add_cycle(n = 5)

# Get a count of asymmetrically-
# connected node pairs
graph \%>\%
  count_asymmetric_node_pairs()

# Create a full graph and then
# count the asymmetrically-
# connected node pairs
create_graph() \%>\%
  add_full_graph(n = 10) \%>\%
  count_asymmetric_node_pairs()
}
