% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale_edge_attrs.R
\name{rescale_edge_attrs}
\alias{rescale_edge_attrs}
\title{Rescale numeric edge attribute values}
\usage{
rescale_edge_attrs(graph, edge_attr_from, to_lower_bound = 0,
  to_upper_bound = 1, edge_attr_to = NULL, from_lower_bound = NULL,
  from_upper_bound = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{edge_attr_from}{the edge attribute containing
numeric data that is to be rescaled to new numeric
or color values.}

\item{to_lower_bound}{the lower bound value for the
set of rescaled values. This can be a numeric value
or an X11 color name.}

\item{to_upper_bound}{the upper bound value for the
set of rescaled values. This can be a numeric value
or an X11 color name.}

\item{edge_attr_to}{an optional name of a new edge
attribute to which the recoded values will be
applied. This will retain the original edge
attribute and its values.}

\item{from_lower_bound}{an optional, manually set
lower bound value for the rescaled values. If not
set, the minimum value from the set will be used.}

\item{from_upper_bound}{an optional, manually set
upper bound value for the rescaled values. If not
set, the minimum value from the set will be used.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class
\code{dgr_graph}, take a set of numeric values for
an edge attribute, rescale to a new numeric or color
range, then write to the same edge attribute or to
a new edge attribute column.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    5, 7, set_seed = 23,
    directed = TRUE) \%>\%
  set_edge_attrs(
    "weight", rnorm(edge_count(.), 5))

# Get the graph's internal edf to show which
# edge attributes are available
get_edge_df(graph)
#>   id from to  rel   weight
#> 1  1    2  3 <NA> 5.218288
#> 2  2    3  5 <NA> 3.953465
#> 3  3    3  4 <NA> 4.711311
#> 4  4    2  4 <NA> 5.481550
#> 5  5    2  5 <NA> 3.783624
#> 6  6    4  5 <NA> 5.308137
#> 7  7    1  4 <NA> 4.479822

# Rescale the `weight` edge attribute, so that
# its values are rescaled between 0 and 1
graph <-
  graph \%>\%
  rescale_edge_attrs("weight")

# Get the graph's internal edf to show that the
# edge attribute values had been rescaled
get_edge_df(graph)
#>   id from to  rel weight
#> 1  1    2  3 <NA>  0.845
#> 2  2    3  5 <NA>  0.100
#> 3  3    3  4 <NA>  0.546
#> 4  4    2  4 <NA>  1.000
#> 5  5    2  5 <NA>  0.000
#> 6  6    4  5 <NA>  0.898
#> 7  7    1  4 <NA>  0.410

# Scale the values in the `weight` edge attribute
# to different shades of gray for the `color` edge
# attribute and different numerical values for the
# `penwidth` attribute
graph <-
  graph \%>\%
  rescale_edge_attrs(
    "weight", "gray80", "gray20", "color") \%>\%
  rescale_edge_attrs(
    "weight", 0.5, 3, "penwidth")

# Get the graph's internal edf once more to show
# that scaled grayscale colors are now available in
# `color` and scaled numerical values are in the
# `penwidth` edge attribute
get_edge_df(graph)
#>   id from to  rel weight   color penwidth
#> 1  1    2  3 <NA>  0.845 #484848    2.612
#> 2  2    3  5 <NA>  0.100 #BBBBBB    0.750
#> 3  3    3  4 <NA>  0.546 #747474    1.865
#> 4  4    2  4 <NA>  1.000 #333333    3.000
#> 5  5    2  5 <NA>  0.000 #CCCCCC    0.500
#> 6  6    4  5 <NA>  0.898 #414141    2.745
#> 7  7    1  4 <NA>  0.410 #898989    1.525
}

