% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cmty_fast_greedy.R
\name{get_cmty_fast_greedy}
\alias{get_cmty_fast_greedy}
\title{Get community membership by modularity optimization}
\usage{
get_cmty_fast_greedy(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a data frame with group membership
assignments for each of the nodes.
}
\description{
Through the use of greedy optimization
of a modularity score, obtain the group membership
values for each of the nodes in the graph.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    10, 22, set_seed = 23)

# Get the group membership values for all nodes
# in the graph through the greedy optimization
# of modularity algorithm
get_cmty_fast_greedy(graph)
#>    id f_g_group
#> 1   1         1
#> 2   2         2
#> 3   3         2
#> 4   4         1
#> 5   5         1
#> 6   6         1
#> 7   7         2
#> 8   8         1
#> 9   9         2
#> 10 10         1

# Add the group membership values to the graph
# as a node attribute
graph <-
  graph \%>\%
  join_node_attrs(get_cmty_fast_greedy(.))
}

