% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cmty_edge_btwns.R
\name{get_cmty_edge_btwns}
\alias{get_cmty_edge_btwns}
\title{Get community membership by edge betweenness}
\usage{
get_cmty_edge_btwns(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a data frame with group membership
assignments for each of the nodes.
}
\description{
Using edge betweenness, obtain the
group membership values for each of the nodes in
the graph.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    10, 22, set_seed = 1)

# Get the group membership values for all nodes
# in the graph through calculation of the leading
# non-negative eigenvector of the modularity matrix
# of the graph
get_cmty_edge_btwns(graph)
#>    id edge_btwns_group
#> 1   1                1
#> 2   2                1
#> 3   3                1
#> 4   4                2
#> 5   5                1
#> 6   6                2
#> 7   7                1
#> 8   8                1
#> 9   9                2
#> 10 10                1

# Add the group membership values to the graph
# as a node attribute
graph <-
  graph \%>\%
  join_node_attrs(get_cmty_edge_btwns(.))
}

