% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_node_attrs.R
\name{copy_node_attrs}
\alias{copy_node_attrs}
\title{Copy a node attribute column and set the name}
\usage{
copy_node_attrs(graph, node_attr_from, node_attr_to)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{node_attr_from}{the name of the node attribute
column from which values will be copied.}

\item{node_attr_to}{the name of the new node
attribute column to which the copied values will be
placed.}
}
\value{
a graph object of class
\code{dgr_graph}.
}
\description{
Within a graph's internal node data
frame (ndf), copy the contents an existing node
attribute and create a distinct node attribute
within the ndf with a different attribute name.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    5, 10, set_seed = 3) \%>\%
  set_node_attrs("shape", "circle")

# Get the graph's internal ndf to show which
# node attributes are available
get_node_df(graph)
#>   id type label value  shape
#> 1  1 <NA>     1   2.0 circle
#> 2  2 <NA>     2   8.5 circle
#> 3  3 <NA>     3   4.0 circle
#> 4  4 <NA>     4   3.5 circle
#> 5  5 <NA>     5   6.5 circle

# Make a copy the `value` node attribute as
# the `width` node attribute
graph <-
  graph \%>\%
  copy_node_attrs("value", "size")

# Get the graph's internal ndf to show that the
# node attribute had been copied
get_node_df(graph)
#>   id type label value  shape size
#> 1  1 <NA>     1   2.0 circle  2.0
#> 2  2 <NA>     2   8.5 circle  8.5
#> 3  3 <NA>     3   4.0 circle  4.0
#> 4  4 <NA>     4   3.5 circle  3.5
#> 5  5 <NA>     5   6.5 circle  6.5
}

