% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_star.R
\name{add_star}
\alias{add_star}
\title{Add a star of nodes to the graph}
\usage{
add_star(graph, n, type = NULL, label = TRUE, rel = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{n}{the number of nodes comprising the star.
The first node will be the center of the star.}

\item{type}{an optional string that describes the
entity type for the nodes to be added.}

\item{label}{either a vector object of length
\code{n} that provides optional labels for the new
nodes, or, a boolean value where setting to
\code{TRUE} ascribes node IDs to the label and
\code{FALSE} yields a blank label.}

\item{rel}{an optional string for providing a
relationship label to all new edges created in the
node star.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class
\code{dgr_graph}, add a node star to the graph.
}
\examples{
# Create a new graph and add 2 stars of varying
# numbers of nodes
graph <-
  create_graph() \%>\%
  add_star(4, "four_star") \%>\%
  add_star(5, "five_star")

# Get node information from this graph
node_info(graph)
#>   id      type label deg indeg outdeg loops
#> 1  1 four_star     1   3     0      3     0
#> 2  2 four_star     2   1     1      0     0
#> 3  3 four_star     3   1     1      0     0
#> 4  4 four_star     4   1     1      0     0
#> 5  5 five_star     1   4     0      4     0
#> 6  6 five_star     2   1     1      0     0
#> 7  7 five_star     3   1     1      0     0
#> 8  8 five_star     4   1     1      0     0
#> 9  9 five_star     5   1     1      0     0
}

