% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_path.R
\name{add_path}
\alias{add_path}
\title{Add a path of nodes to the graph}
\usage{
add_path(graph, n, type = NULL, label = TRUE, rel = NULL, nodes = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}.}

\item{n}{the number of nodes comprising the path.}

\item{type}{an optional string that describes the
entity type for the nodes to be added.}

\item{label}{either a vector object of length
\code{n} that provides optional labels for the new
nodes, or, a boolean value where setting to
\code{TRUE} ascribes node IDs to the label and
\code{FALSE} yields a blank label.}

\item{rel}{an optional string for providing a
relationship label to all new edges created in the
node path.}

\item{nodes}{an optional vector of node IDs of
length \code{n} for the newly created nodes. If
nothing is provided, node IDs will assigned as
monotonically increasing integers.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class
\code{dgr_graph}, add a node path to the graph.
}
\examples{
library(magrittr)

# Create a new graph and add 3 paths of varying
# lengths
graph <-
  create_graph() \%>\%
  add_path(4, "four_path") \%>\%
  add_path(5, "five_path") \%>\%
  add_path(6, "six_path")

# Get node information from this graph
node_info(graph)
#>    node label      type deg indeg outdeg loops
#> 1     1     1 four_path   1     0      1     0
#> 2     5     5 five_path   1     0      1     0
#> 3    10    10  six_path   1     0      1     0
#> 4     2     2 four_path   2     1      1     0
#> 5     3     3 four_path   2     1      1     0
#> 6     6     6 five_path   2     1      1     0
#> 7     7     7 five_path   2     1      1     0
#> 8     8     8 five_path   2     1      1     0
#> 9    11    11  six_path   2     1      1     0
#> 10   12    12  six_path   2     1      1     0
#> 11   13    13  six_path   2     1      1     0
#> 12   14    14  six_path   2     1      1     0
#> 13    4     4 four_path   1     1      0     0
#> 14    9     9 five_path   1     1      0     0
#> 15   15    15  six_path   1     1      0     0
}

