% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Avg..R
\name{Avg.}
\alias{Avg.}
\title{Varying Life Insurance: Geometric Progression}
\usage{
Avg.(
  x,
  h,
  n,
  k = 1,
  r,
  i = 0.04,
  data,
  prop = 1,
  assumption = "none",
  variation = "none",
  cap = 1
)
}
\arguments{
\item{x}{An integer. The age of the insuree.}

\item{h}{An integer. The deferral period.}

\item{n}{An integer. Number of years of coverage.}

\item{k}{An integer. Fractions per year.}

\item{r}{The variation rate. A numeric type value.}

\item{i}{The interest rate. A numeric type value.}

\item{data}{A data.frame of the mortality table, with the first column being the age and the second one the probability of death.}

\item{prop}{A numeric value. It represents the proportion of the mortality table being used (between 0 and 1).}

\item{assumption}{A character string. The assumption used for fractional ages ("UDD" for uniform distribution of deaths, "constant" for constant force of mortality and "none" if there is no fractional coverage).}

\item{variation}{A character string. "inter" if the variation it's interannual or "intra" if it's intra-annual.}

\item{cap}{A numeric type value. Amount insured for the first year/period.}
}
\value{
Returns a numeric value (actuarial present value).
}
\description{
Calculates the present value of a varying life insurance according to a geometric progression.
}
\examples{
Avg.(33,0,5,1,0.8,0.04,CSO80MANB,1,"none","none",1)
Avg.(26,2,4,1,0.4,0.04,CSO80MANB,1,"none","none",1)
Avg.(25,0,15,2,0.25,0.04,CSO80MANB,1,"constant","inter",1)
Avg.(37,10,10,4,0.05,0.04,CSO80MANB,1,"constant","intra",1)
Avg.(40,5,20,6,0.04,0.04,CSO80MANB,1,"UDD","inter",1)
Avg.(20,0,80,12,0.01,0.04,CSO80MANB,1,"UDD","intra",1)

}
\references{
Chapter 4 of  Actuarial Mathematics for Life Contingent Risks (2009) by Dickson, Hardy and Waters.
}
\keyword{Geometric}
\keyword{Insurance}
\keyword{Life}
\keyword{Progression}
