% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_arm_designer.R
\name{multi_arm_designer}
\alias{multi_arm_designer}
\title{Create a design with multiple experimental arms}
\usage{
multi_arm_designer(
  N = 30,
  m_arms = 3,
  outcome_means = rep(0, m_arms),
  sd_i = 1,
  outcome_sds = rep(0, m_arms),
  conditions = 1:m_arms,
  args_to_fix = NULL
)
}
\arguments{
\item{N}{An integer. Sample size.}

\item{m_arms}{An integer. Number of arms.}

\item{outcome_means}{A numeric vector of length \code{m_arms}.  Average outcome in each arm.}

\item{sd_i}{A nonnegative scalar. Standard deviation of individual-level shock (common across arms).}

\item{outcome_sds}{A nonnegative numeric vector of length \code{m_arms}. Standard deviations for condition-level shocks.}

\item{conditions}{A vector of length \code{m_arms}. The names of each arm. It can be given as numeric or character class (without blank spaces).}

\item{args_to_fix}{A character vector. Names of arguments to be args_to_fix in design. By default, \code{m_arms} and \code{conditions} are always args_to_fix.}
}
\value{
A function that returns a design.
}
\description{
Creates a design with \code{m_arms} experimental arms, each assigned with equal probability.
}
\details{
See \href{https://declaredesign.org/r/designlibrary/articles/multi_arm.html}{vignette online}.
}
\examples{

# To make a design using default arguments:
design <- multi_arm_designer()


# A design with different means and standard deviations in each arm
design <- multi_arm_designer(outcome_means = c(0, 0.5, 2), outcome_sds =  c(1, 0.1, 0.5))

design <- multi_arm_designer(N = 80, m_arms = 4, outcome_means = 1:4,
                             args_to_fix = c("outcome_means", "outcome_sds"))

}
\author{
\href{https://declaredesign.org/}{DeclareDesign Team}
}
\concept{experiment}
\concept{multiarm trial}
