% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DepLogoR.R
\name{plotDeplogo}
\alias{plotDeplogo}
\alias{plotDeplogo.DLData}
\title{Plot a dependency logo}
\usage{
plotDeplogo(
  data,
  dep.fun = plotDeparcs,
  block.fun = deprects,
  summary.fun = logo,
  weight.fun = NULL,
  chunks = NULL,
  chunk.height = 800,
  summary.height = 100,
  minPercent = 0.03,
  threshold = 0.1,
  numBestForSorting = 3,
  maxNum = 6,
  sortByWeights = NULL,
  dep.fun.legend = TRUE,
  show.dependency.pvals = FALSE,
  axis.labels = NULL,
  weight.ratio = 5,
  partition.by = NULL,
  ...
)

\method{plotDeplogo}{DLData}(
  data,
  dep.fun = plotDeparcs,
  block.fun = deprects,
  summary.fun = logo,
  weight.fun = NULL,
  chunks = NULL,
  chunk.height = 800,
  summary.height = 100,
  minPercent = 0.03,
  threshold = 0.1,
  numBestForSorting = 3,
  maxNum = 6,
  sortByWeights = NULL,
  dep.fun.legend = TRUE,
  show.dependency.pvals = FALSE,
  axis.labels = NULL,
  weight.ratio = 5,
  partition.by = NULL,
  ...
)
}
\arguments{
\item{data}{the data, currently implemented for \link{DLData} objects}

\item{dep.fun}{the function for plotting the representation of dependency
values (as computed by \link{getDeps})}

\item{block.fun}{the function for plotting a representation of the individual
partitions of the data generated in dependency logos.}

\item{summary.fun}{the function for plotting a representation of the summary
plot for (one chunk of) the data}

\item{weight.fun}{the function for plotting a representation of the
\code{weights} values of the sequences within one partition}

\item{chunks}{the size of chunks the data is split into. The sum of the chunk
sizes must not be greater than the number of data points in data; The
default value of NULL corresponds to one chunk containing all data points}

\item{chunk.height}{the (relative) height of the parts of the plot
representing each of the chunks, one height for each chunk}

\item{summary.height}{the (relative) height of the block summaries in the
plot}

\item{minPercent}{the minimum percentage of the (sub) data set that may
constitute its own partition in the dependency logo}

\item{threshold}{the threshold on the dependency value for further splits}

\item{numBestForSorting}{the number of dependencies between position i and
all other positions when computing the dependency value of position i}

\item{maxNum}{the maximum number of splits allowed}

\item{sortByWeights}{are partitions sorted by their average weight
(descending)}

\item{dep.fun.legend}{if \code{TRUE}, a legend of the color scale used for
plotting the dependency values in \code{dep.fun} is added to the plot}

\item{show.dependency.pvals}{is \code{TRUE}, p-values are used for plotting
dependency values in \code{dep.fun} instead of mutual information values}

\item{axis.labels}{labels for the x-axis, vector of the same length as the
individual sequences}

\item{weight.ratio}{the factor by which the plotting width for the main plot is larger than for \code{weight.fun}}

\item{partition.by}{specify fixed positions to partition by}

\item{...}{forwarded to the high-level \code{plot} that contains the blocks
plotted by \code{block.fun}}
}
\value{
a list of \link{DLData} objects with the partitions created for the
  dependency logo
}
\description{
Plots a dependency logo
}
\details{
The function \code{dep.fun} provided for plotting the representation of
dependencies is currently implemented in \link{plotDeparcs} and
\link{plotDepmatrix}. Custom implementations must have the same signature as
these functions and create a single plot without using
\link[graphics]{layout} (or similar).

The functions \code{block.fun} and \code{summary.fun} provided for plotting
the representation of individual partitions of the data generated in
dependency logos are currently implemented in \link{deprects},
\link{colorchart}, and \link{logo}. Custom implementations must have the same
signature as these functions and create a single plot without using
\link[graphics]{layout} (or similar).

The function \code{weight.fun} for plotting a representation of the
\code{weights} values of the sequences within one partition is currently
implemented in \link{subLines} and \link{subBoxes}. Custom implementations
must have the same signature as these functions and create a single plot
without using \link[graphics]{layout} (or similar).
}
\examples{
# read data and create DLData object
seqs <- read.table(system.file("extdata", "cjun.txt", package = "DepLogo"), 
    stringsAsFactors = FALSE)
data <- DLData(sequences = seqs[, 1],weights = log1p(seqs[, 2]) )

# plot default dependency logo
plotDeplogo(data)

# refine threshold for clearer picture
plotDeplogo(data, threshold = 0.3)

# customize different parts of the plot
plotDeplogo(data, threshold = 0.3, dep.fun = plotDepmatrix, block.fun = colorchart)

# add plots of the weights
plotDeplogo(data, weight.fun = subBoxes)
}
\author{
Jan Grau <grau@informatik.uni-halle.de>
}
