/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.models.GLMModel;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class GLMExplorerOptions
extends JDialog
implements ActionListener {
    private JPanel modelInfPanel;
    private JCheckBox anova;
    private JLabel type;
    private JCheckBox summary;
    private JPanel okayCancel;
    private JCheckBox influence;
    private JCheckBox vif;
    private JSeparator sep;
    private JPanel diagPanel;
    private JCheckBox cor;
    private JRadioButton testF;
    private JRadioButton testWald;
    private JRadioButton testLR;
    private JLabel test;
    private JRadioButton typeIII;
    private JRadioButton typeII;
    private GLMModel model;

    public GLMExplorerOptions(JFrame jFrame, GLMModel gLMModel) {
        super(jFrame);
        this.initGUI();
        this.setModel(gLMModel);
        this.setModal(true);
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.modelInfPanel = new JPanel();
            this.getContentPane().add(this.modelInfPanel);
            this.modelInfPanel.setBounds(17, 12, 260, 155);
            this.modelInfPanel.setBorder(BorderFactory.createTitledBorder("Tables"));
            this.modelInfPanel.setLayout(null);
            this.anova = new JCheckBox();
            this.modelInfPanel.add(this.anova);
            this.anova.setText("Anova Table");
            this.anova.setBounds(17, 20, 227, 19);
            this.type = new JLabel();
            this.modelInfPanel.add(this.type);
            this.type.setText("Type:");
            this.type.setBounds(17, 45, 53, 15);
            this.type.setHorizontalAlignment(4);
            this.typeII = new JRadioButton();
            this.modelInfPanel.add(this.typeII);
            this.typeII.setText("II");
            this.typeII.setBounds(76, 43, 51, 19);
            this.typeIII = new JRadioButton();
            this.modelInfPanel.add(this.typeIII);
            this.typeIII.setText("III");
            this.typeIII.setBounds(127, 43, 51, 19);
            this.summary = new JCheckBox();
            this.modelInfPanel.add(this.summary);
            this.summary.setText("Summary Table");
            this.summary.setBounds(17, 99, 204, 19);
            this.test = new JLabel();
            this.modelInfPanel.add(this.test);
            this.test.setText("Test:");
            this.test.setBounds(17, 66, 53, 15);
            this.test.setHorizontalAlignment(4);
            this.testLR = new JRadioButton();
            this.modelInfPanel.add(this.testLR);
            this.testLR.setText("LR");
            this.testLR.setBounds(76, 64, 51, 19);
            this.testWald = new JRadioButton();
            this.modelInfPanel.add(this.testWald);
            this.testWald.setText("Wald");
            this.testWald.setBounds(127, 64, 70, 19);
            this.testF = new JRadioButton();
            this.modelInfPanel.add(this.testF);
            this.testF.setText("F");
            this.testF.setBounds(195, 64, 40, 19);
            this.cor = new JCheckBox();
            this.modelInfPanel.add(this.cor);
            this.cor.setText("Parameter Correlations");
            this.cor.setBounds(37, 120, 189, 19);
            this.sep = new JSeparator();
            this.modelInfPanel.add(this.sep);
            this.sep.setBounds(61, 89, 113, 10);
            this.diagPanel = new JPanel();
            this.getContentPane().add(this.diagPanel);
            this.diagPanel.setBounds(17, 173, 260, 89);
            this.diagPanel.setBorder(BorderFactory.createTitledBorder("Model Diagnostics"));
            this.diagPanel.setLayout(null);
            this.vif = new JCheckBox();
            this.diagPanel.add(this.vif);
            this.vif.setText("Variance Inflation Factors");
            this.vif.setBounds(17, 20, 226, 19);
            this.influence = new JCheckBox();
            this.diagPanel.add(this.influence);
            this.influence.setText("Influence Summary");
            this.influence.setBounds(17, 45, 226, 19);
            this.okayCancel = new OkayCancelPanel(false, false, this);
            this.getContentPane().add(this.okayCancel);
            this.okayCancel.setBounds(88, 268, 189, 31);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.typeII);
            buttonGroup.add(this.typeIII);
            ButtonGroup buttonGroup2 = new ButtonGroup();
            buttonGroup2.add(this.testWald);
            buttonGroup2.add(this.testLR);
            buttonGroup2.add(this.testF);
            this.setTitle("Options");
            this.setSize(289, 333);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void setModel(GLMModel gLMModel) {
        this.model = gLMModel;
        this.anova.setSelected(gLMModel.options.anova);
        this.typeII.setSelected(true);
        this.typeIII.setSelected(gLMModel.options.type == "III");
        this.testWald.setSelected(true);
        if (gLMModel.options.test == "LR") {
            this.testLR.setSelected(true);
        } else if (gLMModel.options.test == "F") {
            this.testF.setSelected(true);
        }
        if (!gLMModel.family.startsWith("gaussian()")) {
            this.testF.setEnabled(false);
        }
        this.summary.setSelected(gLMModel.options.summary);
        this.cor.setSelected(gLMModel.options.paramCor);
        this.vif.setSelected(gLMModel.options.vif);
        this.influence.setSelected(gLMModel.options.influence);
    }

    public void updateModel() {
        this.model.options.anova = this.anova.isSelected();
        String string = this.model.options.type = this.typeII.isSelected() ? "II" : "III";
        this.model.options.test = this.testWald.isSelected() ? "Wald" : (this.testF.isSelected() ? "F" : "LR");
        this.model.options.summary = this.summary.isSelected();
        this.model.options.paramCor = this.cor.isSelected();
        this.model.options.vif = this.vif.isSelected();
        this.model.options.influence = this.influence.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "OK") {
            this.updateModel();
            this.dispose();
        } else if (string == "Cancel") {
            this.dispose();
        }
    }
}

