/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.JRI;

import org.rosuda.JRI.Mutex;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPEnvironment;
import org.rosuda.REngine.REXPFactor;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPJavaReference;
import org.rosuda.REngine.REXPLanguage;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPNull;
import org.rosuda.REngine.REXPRaw;
import org.rosuda.REngine.REXPReference;
import org.rosuda.REngine.REXPS4;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPSymbol;
import org.rosuda.REngine.REXPUnknown;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineCallbacks;
import org.rosuda.REngine.REngineConsoleHistoryInterface;
import org.rosuda.REngine.REngineEvalException;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.REngineInputInterface;
import org.rosuda.REngine.REngineOutputInterface;
import org.rosuda.REngine.REngineUIInterface;
import org.rosuda.REngine.RList;

public class JRIEngine
extends REngine
implements RMainLoopCallbacks {
    static final int NILSXP = 0;
    static final int SYMSXP = 1;
    static final int LISTSXP = 2;
    static final int CLOSXP = 3;
    static final int ENVSXP = 4;
    static final int PROMSXP = 5;
    static final int LANGSXP = 6;
    static final int SPECIALSXP = 7;
    static final int BUILTINSXP = 8;
    static final int CHARSXP = 9;
    static final int LGLSXP = 10;
    static final int INTSXP = 13;
    static final int REALSXP = 14;
    static final int CPLXSXP = 15;
    static final int STRSXP = 16;
    static final int DOTSXP = 17;
    static final int ANYSXP = 18;
    static final int VECSXP = 19;
    static final int EXPRSXP = 20;
    static final int BCODESXP = 21;
    static final int EXTPTRSXP = 22;
    static final int WEAKREFSXP = 23;
    static final int RAWSXP = 24;
    static final int S4SXP = 25;
    public static final long requiredAPIversion = 266L;
    static JRIEngine jriEngine = null;
    Rengine rni = null;
    REngineCallbacks callbacks = null;
    Mutex rniMutex = null;
    long R_UnboundValue;
    long R_NilValue;
    public REXPReference globalEnv;
    public REXPReference emptyEnv;
    public REXPReference baseEnv;
    public REXPReference nullValueRef;
    public REXPNull nullValue;

    public static REngine createEngine() throws REngineException {
        if (jriEngine == null) {
            jriEngine = new JRIEngine();
        }
        return jriEngine;
    }

    public static REngine createEngine(String[] stringArray, REngineCallbacks rEngineCallbacks, boolean bl) throws REngineException {
        if (jriEngine != null) {
            throw new REngineException(jriEngine, "engine already running - cannot use extended constructor on a running instance");
        }
        jriEngine = new JRIEngine(stringArray, rEngineCallbacks, bl);
        return jriEngine;
    }

    public Rengine getRni() {
        return this.rni;
    }

    public JRIEngine() throws REngineException {
        this(new String[]{"--no-save"}, (REngineCallbacks)null, false);
    }

    public JRIEngine(String[] stringArray) throws REngineException {
        this(stringArray, (REngineCallbacks)null, false);
    }

    public JRIEngine(String[] stringArray, RMainLoopCallbacks rMainLoopCallbacks) throws REngineException {
        this(stringArray, rMainLoopCallbacks, rMainLoopCallbacks != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRIEngine(String[] stringArray, REngineCallbacks rEngineCallbacks, boolean bl) throws REngineException {
        if (!Rengine.jriLoaded) {
            throw new REngineException(null, "Cannot load JRI native library");
        }
        if (Rengine.getVersion() < 266L) {
            throw new REngineException(null, "JRI API version is too old, update rJava/JRI to match the REngine API");
        }
        this.callbacks = rEngineCallbacks;
        this.rni = new Rengine(stringArray, bl, (RMainLoopCallbacks)(rEngineCallbacks == null ? null : this));
        this.rniMutex = this.rni.getRsync();
        boolean bl2 = this.rniMutex.safeLock();
        try {
            if (!this.rni.waitForR()) {
                throw new REngineException(this, "Unable to initialize R");
            }
            JRIEngine jRIEngine = this;
            if (jRIEngine.rni.rniGetVersion() < 266L) {
                throw new REngineException(this, "JRI API version is too old, update rJava/JRI to match the REngine API");
            }
            this.globalEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(1)));
            this.R_NilValue = this.rni.rniSpecialObject(0);
            this.nullValueRef = new REXPReference((REngine)this, new Long(this.R_NilValue));
            this.emptyEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(2)));
            this.baseEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(3)));
            this.nullValue = new REXPNull();
            this.R_UnboundValue = this.rni.rniSpecialObject(4);
        }
        finally {
            if (bl2) {
                this.rniMutex.unlock();
            }
        }
        lastEngine = this;
        if (jriEngine == null) {
            jriEngine = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRIEngine(String[] stringArray, RMainLoopCallbacks rMainLoopCallbacks, boolean bl) throws REngineException {
        if (!Rengine.jriLoaded) {
            throw new REngineException(null, "Cannot load JRI native library");
        }
        if (Rengine.getVersion() < 266L) {
            throw new REngineException(null, "JRI API version is too old, update rJava/JRI to match the REngine API");
        }
        this.rni = new Rengine(stringArray, bl, rMainLoopCallbacks);
        this.rniMutex = this.rni.getRsync();
        boolean bl2 = this.rniMutex.safeLock();
        try {
            if (!this.rni.waitForR()) {
                throw new REngineException(this, "Unable to initialize R");
            }
            JRIEngine jRIEngine = this;
            if (jRIEngine.rni.rniGetVersion() < 266L) {
                throw new REngineException(this, "JRI API version is too old, update rJava/JRI to match the REngine API");
            }
            this.globalEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(1)));
            this.R_NilValue = this.rni.rniSpecialObject(0);
            this.nullValueRef = new REXPReference((REngine)this, new Long(this.R_NilValue));
            this.emptyEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(2)));
            this.baseEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(3)));
            this.nullValue = new REXPNull();
            this.R_UnboundValue = this.rni.rniSpecialObject(4);
        }
        finally {
            if (bl2) {
                this.rniMutex.unlock();
            }
        }
        lastEngine = this;
        if (jriEngine == null) {
            jriEngine = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRIEngine(Rengine rengine) throws REngineException {
        if (!Rengine.jriLoaded) {
            throw new REngineException(null, "Cannot load JRI native library");
        }
        this.rni = rengine;
        JRIEngine jRIEngine = this;
        if (jRIEngine.rni.rniGetVersion() < 265L) {
            throw new REngineException(this, "R JRI engine is too old - RNI API 1.9 (JRI 0.5) or newer is required");
        }
        this.rniMutex = this.rni.getRsync();
        boolean bl = this.rniMutex.safeLock();
        try {
            this.globalEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(1)));
            this.R_NilValue = this.rni.rniSpecialObject(0);
            this.nullValueRef = new REXPReference((REngine)this, new Long(this.R_NilValue));
            this.emptyEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(2)));
            this.baseEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(3)));
            this.nullValue = new REXPNull();
            this.R_UnboundValue = this.rni.rniSpecialObject(4);
        }
        finally {
            if (bl) {
                this.rniMutex.unlock();
            }
        }
        lastEngine = this;
        if (jriEngine == null) {
            jriEngine = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP parse(String string, boolean bl) throws REngineException {
        REXP rEXP = null;
        boolean bl2 = this.rniMutex.safeLock();
        try {
            long l = this.rni.rniParse(string, -1);
            if (l == 0L || l == this.R_NilValue) {
                throw new REngineException(this, "Parse error");
            }
            this.rni.rniPreserve(l);
            rEXP = new REXPReference((REngine)this, new Long(l));
            if (bl) {
                try {
                    rEXP = this.resolveReference(rEXP);
                }
                catch (REXPMismatchException rEXPMismatchException) {
                    // empty catch block
                }
            }
        }
        finally {
            if (bl2) {
                this.rniMutex.unlock();
            }
        }
        return rEXP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP eval(REXP rEXP, REXP rEXP2, boolean bl) throws REngineException, REXPMismatchException {
        REXP rEXP3 = null;
        long l = 0L;
        if (rEXP2 != null && !rEXP2.isReference()) {
            if (!rEXP2.isEnvironment() || ((REXPEnvironment)rEXP2).getHandle() == null) {
                throw new REXPMismatchException(rEXP2, "environment");
            }
            l = ((JRIPointer)((REXPEnvironment)rEXP2).getHandle()).pointer();
        } else if (rEXP2 != null) {
            l = (Long)((REXPReference)rEXP2).getHandle();
        }
        if (rEXP == null) {
            throw new REngineException(this, "null object to evaluate");
        }
        if (!rEXP.isReference()) {
            if (rEXP.isExpression() || rEXP.isLanguage()) {
                rEXP = this.createReference(rEXP);
            } else {
                throw new REXPMismatchException(rEXP2, "reference, expression or language");
            }
        }
        boolean bl2 = this.rniMutex.safeLock();
        try {
            long l2 = this.rni.rniEval(((Long)((REXPReference)rEXP).getHandle()).longValue(), l);
            if (l2 == -1L) {
                throw new REngineEvalException(this, "Eval error (invalid input)", -1);
            }
            if (l2 == -2L) {
                throw new REngineEvalException(this, "error during evaluation", -2);
            }
            this.rni.rniPreserve(l2);
            rEXP3 = new REXPReference((REngine)this, new Long(l2));
            if (bl) {
                rEXP3 = this.resolveReference(rEXP3);
            }
        }
        finally {
            if (bl2) {
                this.rniMutex.unlock();
            }
        }
        return rEXP3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(String string, REXP rEXP, REXP rEXP2) throws REngineException, REXPMismatchException {
        long l = 0L;
        if (rEXP2 != null && !rEXP2.isReference()) {
            if (!rEXP2.isEnvironment() || ((REXPEnvironment)rEXP2).getHandle() == null) {
                throw new REXPMismatchException(rEXP2, "environment");
            }
            l = ((JRIPointer)((REXPEnvironment)rEXP2).getHandle()).pointer();
        } else if (rEXP2 != null) {
            l = (Long)((REXPReference)rEXP2).getHandle();
        }
        if (rEXP == null) {
            rEXP = this.nullValueRef;
        }
        if (!rEXP.isReference()) {
            rEXP = this.createReference(rEXP);
        }
        boolean bl = this.rniMutex.safeLock();
        boolean bl2 = false;
        try {
            bl2 = this.rni.rniAssign(string, ((Long)((REXPReference)rEXP).getHandle()).longValue(), l);
        }
        finally {
            if (bl) {
                this.rniMutex.unlock();
            }
        }
        if (!bl2) {
            throw new REngineException(this, "assign failed (probably locked binding");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP get(String string, REXP rEXP, boolean bl) throws REngineException, REXPMismatchException {
        REXP rEXP2 = null;
        long l = 0L;
        if (rEXP != null && !rEXP.isReference()) {
            if (!rEXP.isEnvironment() || ((REXPEnvironment)rEXP).getHandle() == null) {
                throw new REXPMismatchException(rEXP, "environment");
            }
            l = ((JRIPointer)((REXPEnvironment)rEXP).getHandle()).pointer();
        } else if (rEXP != null) {
            l = (Long)((REXPReference)rEXP).getHandle();
        }
        boolean bl2 = this.rniMutex.safeLock();
        try {
            long l2 = this.rni.rniFindVar(string, l);
            if (l2 == this.R_UnboundValue || l2 == 0L) {
                REXP rEXP3 = null;
                return rEXP3;
            }
            this.rni.rniPreserve(l2);
            rEXP2 = new REXPReference((REngine)this, new Long(l2));
            if (bl) {
                try {
                    rEXP2 = this.resolveReference(rEXP2);
                }
                catch (REXPMismatchException rEXPMismatchException) {
                    // empty catch block
                }
            }
        }
        finally {
            if (bl2) {
                this.rniMutex.unlock();
            }
        }
        return rEXP2;
    }

    public REXP resolveReference(REXP rEXP) throws REngineException, REXPMismatchException {
        Object var2_2 = null;
        if (rEXP == null) {
            throw new REngineException(this, "resolveReference called on NULL input");
        }
        if (!rEXP.isReference()) {
            throw new REXPMismatchException(rEXP, "reference");
        }
        long l = (Long)((REXPReference)rEXP).getHandle();
        if (l == 0L) {
            return this.nullValue;
        }
        return this.resolvePointer(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    REXP resolvePointer(long l) throws REngineException, REXPMismatchException {
        if (l == 0L) {
            return this.nullValue;
        }
        Object var3_2 = null;
        boolean bl = this.rniMutex.safeLock();
        try {
            int n;
            String[] stringArray;
            int n2 = this.rni.rniExpType(l);
            String[] stringArray2 = this.rni.rniGetAttrNames(l);
            REXPList rEXPList = null;
            if (stringArray2 != null && stringArray2.length > 0) {
                void var10_25;
                long l2 = 0L;
                Object var10_24 = null;
                stringArray = new RList();
                for (n = 0; n < stringArray2.length; ++n) {
                    REXP rEXP;
                    long l3 = this.rni.rniGetAttr(l, stringArray2[n]);
                    if (l3 == 0L || l3 == this.R_NilValue) continue;
                    if (stringArray2[n].equals("jobj")) {
                        l2 = l3;
                    }
                    if ((rEXP = this.resolvePointer(l3)) == null || rEXP == this.nullValue) continue;
                    stringArray.put(stringArray2[n], rEXP);
                    if (!stringArray2[n].equals("class") || !rEXP.isString()) continue;
                    String string = rEXP.asString();
                }
                if (stringArray.size() > 0) {
                    rEXPList = new REXPList((RList)stringArray);
                }
                if (l2 != 0L && var10_25 != null && (var10_25.equals("jobjRef") || var10_25.equals("jarrayRef") || var10_25.equals("jrectRef"))) {
                    REXPJavaReference rEXPJavaReference = new REXPJavaReference(this.rni.rniXrefToJava(l2), rEXPList);
                    return rEXPJavaReference;
                }
            }
            switch (n2) {
                case 0: {
                    REXPNull rEXPNull = this.nullValue;
                    return rEXPNull;
                }
                case 16: {
                    void var3_16;
                    String[] stringArray3 = this.rni.rniGetStringArray(l);
                    REXPString rEXPString = new REXPString(stringArray3, rEXPList);
                    return var3_16;
                }
                case 13: {
                    void var3_5;
                    long l4;
                    void var3_16;
                    if (this.rni.rniInherits(l, "factor") && (l4 = this.rni.rniGetAttr(l, "levels")) != 0L) {
                        stringArray = null;
                        n = this.rni.rniExpType(l4);
                        if (n == 16) {
                            stringArray = this.rni.rniGetStringArray(l4);
                            int[] nArray = this.rni.rniGetIntArray(l);
                            REXPFactor rEXPFactor = new REXPFactor(nArray, stringArray, rEXPList);
                        }
                    }
                    if (var3_5 != null) return var3_16;
                    REXPInteger rEXPInteger = new REXPInteger(this.rni.rniGetIntArray(l), rEXPList);
                    return var3_16;
                }
                case 14: {
                    void var3_16;
                    REXPDouble rEXPDouble = new REXPDouble(this.rni.rniGetDoubleArray(l), rEXPList);
                    return var3_16;
                }
                case 10: {
                    void var3_16;
                    int[] nArray = this.rni.rniGetBoolArrayI(l);
                    byte[] byArray = new byte[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        byArray[i] = nArray[i] == 0 || nArray[i] == 1 ? (byte)nArray[i] : (byte)-128;
                    }
                    REXPLogical rEXPLogical = new REXPLogical(byArray, rEXPList);
                    return var3_16;
                }
                case 19: {
                    void var3_16;
                    long[] lArray = this.rni.rniGetVector(l);
                    REXP[] rEXPArray = new REXP[lArray.length];
                    long l5 = this.rni.rniGetAttr(l, "names");
                    String[] stringArray4 = null;
                    if (l5 != 0L && this.rni.rniExpType(l5) == 16) {
                        stringArray4 = this.rni.rniGetStringArray(l5);
                    }
                    for (int i = 0; i < lArray.length; ++i) {
                        rEXPArray[i] = this.resolvePointer(lArray[i]);
                    }
                    RList rList = stringArray4 == null ? new RList(rEXPArray) : new RList(rEXPArray, stringArray4);
                    REXPGenericVector rEXPGenericVector = new REXPGenericVector(rList, rEXPList);
                    return var3_16;
                }
                case 24: {
                    void var3_16;
                    REXPRaw rEXPRaw = new REXPRaw(this.rni.rniGetRawArray(l), rEXPList);
                    return var3_16;
                }
                case 2: 
                case 6: {
                    void var3_16;
                    RList rList = new RList();
                    long l6 = l;
                    while (l6 != 0L && l6 != this.R_NilValue) {
                        long l7 = this.rni.rniCAR(l6);
                        long l8 = this.rni.rniTAG(l6);
                        String string = null;
                        if (this.rni.rniExpType(l8) == 1) {
                            string = this.rni.rniGetSymbolName(l8);
                        }
                        REXP rEXP = this.resolvePointer(l7);
                        if (string == null) {
                            rList.add(rEXP);
                        } else {
                            rList.put(string, rEXP);
                        }
                        l6 = this.rni.rniCDR(l6);
                    }
                    REXPList rEXPList2 = n2 == 6 ? new REXPLanguage(rList, rEXPList) : new REXPList(rList, rEXPList);
                    return var3_16;
                }
                case 1: {
                    void var3_16;
                    REXPSymbol rEXPSymbol = new REXPSymbol(this.rni.rniGetSymbolName(l));
                    return var3_16;
                }
                case 4: {
                    void var3_16;
                    if (l != 0L) {
                        this.rni.rniPreserve(l);
                    }
                    REXPEnvironment rEXPEnvironment = new REXPEnvironment(this, new JRIPointer(l, false));
                    return var3_16;
                }
                case 25: {
                    void var3_16;
                    REXPS4 rEXPS4 = new REXPS4(rEXPList);
                    return var3_16;
                }
                default: {
                    void var3_16;
                    REXPUnknown rEXPUnknown = new REXPUnknown(n2, rEXPList);
                    return var3_16;
                }
            }
        }
        finally {
            if (bl) {
                this.rniMutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP createReference(REXP rEXP) throws REngineException, REXPMismatchException {
        if (rEXP == null) {
            throw new REngineException(this, "createReference from a NULL value");
        }
        if (rEXP.isReference()) {
            return rEXP;
        }
        long l = this.createReferencePointer(rEXP);
        if (l == 0L) {
            return null;
        }
        boolean bl = this.rniMutex.safeLock();
        try {
            this.rni.rniPreserve(l);
        }
        finally {
            if (bl) {
                this.rniMutex.unlock();
            }
        }
        return new REXPReference((REngine)this, new Long(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long createReferencePointer(REXP rEXP) throws REngineException, REXPMismatchException {
        if (rEXP.isReference()) {
            REXPReference rEXPReference = (REXPReference)rEXP;
            if (rEXPReference.getEngine() != this) {
                throw new REXPMismatchException(rEXP, "reference (cross-engine reference is invalid)");
            }
            return (Long)rEXPReference.getHandle();
        }
        boolean bl = this.rniMutex.safeLock();
        int n = 0;
        try {
            long l;
            long l2;
            Object object;
            int n2;
            long l3 = 0L;
            if (rEXP.isNull()) {
                long l4 = this.R_NilValue;
                return l4;
            }
            if (rEXP.isLogical()) {
                int[] nArray = rEXP.asIntegers();
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = nArray[i] < 0 ? 2 : (nArray[i] == 0 ? 0 : 1);
                }
                l3 = this.rni.rniPutBoolArrayI(nArray);
            } else if (rEXP.isInteger()) {
                l3 = this.rni.rniPutIntArray(rEXP.asIntegers());
            } else if (rEXP.isRaw()) {
                l3 = this.rni.rniPutRawArray(rEXP.asBytes());
            } else if (rEXP.isNumeric()) {
                l3 = this.rni.rniPutDoubleArray(rEXP.asDoubles());
            } else if (rEXP.isString()) {
                l3 = this.rni.rniPutStringArray(rEXP.asStrings());
            } else if (rEXP.isEnvironment()) {
                JRIPointer jRIPointer = (JRIPointer)((REXPEnvironment)rEXP).getHandle();
                if (jRIPointer == null) {
                    long l5 = this.rni.rniParse("new.env(parent=baseenv())", 1);
                    l3 = this.rni.rniEval(l5, 0L);
                } else {
                    l3 = jRIPointer.pointer();
                }
            } else if (rEXP.isPairList()) {
                boolean bl2 = rEXP.isLanguage();
                RList rList = rEXP.asList();
                l3 = this.R_NilValue;
                n2 = rList.size();
                if (n2 == 0) {
                    l3 = this.rni.rniCons(this.R_NilValue, 0L, 0L, bl2);
                } else {
                    for (int i = n2 - 1; i >= 0; --i) {
                        object = rList.at(i);
                        String string = rList.keyAt(i);
                        long l6 = 0L;
                        if (string != null) {
                            l6 = this.rni.rniInstallSymbol(string);
                        }
                        if ((l2 = this.createReferencePointer((REXP)object)) == 0L) {
                            l2 = this.R_NilValue;
                        }
                        l = this.rni.rniCons(l2, l3, l6, i == 0 && bl2);
                        this.rni.rniPreserve(l);
                        this.rni.rniRelease(l3);
                        l3 = l;
                    }
                }
            } else if (rEXP.isList()) {
                int n3 = n;
                RList rList = rEXP.asList();
                long[] lArray = new long[rList.size()];
                for (int i = 0; i < lArray.length; ++i) {
                    object = rList.at(i);
                    if (object == null || ((REXP)object).isNull()) {
                        lArray[i] = this.R_NilValue;
                        continue;
                    }
                    long l7 = this.createReferencePointer((REXP)object);
                    if (l7 != 0L && l7 != this.R_NilValue) {
                        this.rni.rniProtect(l7);
                        ++n;
                    } else {
                        l7 = this.R_NilValue;
                    }
                    lArray[i] = l7;
                }
                l3 = this.rni.rniPutVector(lArray);
                if (n3 > n) {
                    this.rni.rniUnprotect(n - n3);
                    n = n3;
                }
            } else {
                if (rEXP.isSymbol()) {
                    long l8 = this.rni.rniInstallSymbol(rEXP.asString());
                    return l8;
                }
                if (rEXP instanceof REXPJavaReference) {
                    Object object2 = ((REXPJavaReference)rEXP).getObject();
                    long l9 = this.rni.rniJavaToXref(object2);
                    this.rni.rniProtect(l9);
                    long l10 = this.rni.rniInstallSymbol("jobj");
                    long l11 = this.rni.rniInstallSymbol("jclass");
                    String string = "java/lang/Object";
                    if (object2 != null) {
                        string = object2.getClass().getName();
                        string = string.replace('.', '/');
                    }
                    l2 = this.rni.rniPutString(string);
                    this.rni.rniProtect(l2);
                    l = this.rni.rniPutString("jobjRef");
                    this.rni.rniProtect(l);
                    long l12 = this.rni.rniEval(this.rni.rniLCons(this.rni.rniInstallSymbol("new"), this.rni.rniCons(l, this.rni.rniCons(l9, this.rni.rniCons(l2, this.R_NilValue, l11, false), l10, false))), 0L);
                    this.rni.rniUnprotect(3);
                    l3 = l12;
                }
            }
            if (l3 == this.R_NilValue) {
                long l13 = l3;
                return l13;
            }
            if (l3 != 0L) {
                REXPList rEXPList = rEXP._attr();
                if (rEXPList == null || !rEXPList.isPairList()) {
                    long l14 = l3;
                    return l14;
                }
                RList rList = rEXPList.asList();
                if (rList == null || rList.size() < 1 || !rList.isNamed()) {
                    long l15 = l3;
                    return l15;
                }
                this.rni.rniProtect(l3);
                ++n;
                for (n2 = 0; n2 < rList.size(); ++n2) {
                    long l16;
                    REXP rEXP2 = rList.at(n2);
                    object = rList.keyAt(n2);
                    if (object == null || (l16 = this.createReferencePointer(rEXP2)) == 0L || l16 == this.R_NilValue) continue;
                    this.rni.rniSetAttr(l3, (String)object, l16);
                }
                long l17 = l3;
                return l17;
            }
        }
        finally {
            if (n > 0) {
                this.rni.rniUnprotect(n);
            }
            if (bl) {
                this.rniMutex.unlock();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeReference(REXP rEXP) throws REngineException, REXPMismatchException {
        if (rEXP != null && rEXP.isReference()) {
            long l = (Long)((REXPReference)rEXP).getHandle();
            boolean bl = this.rniMutex.safeLock();
            try {
                this.rni.rniRelease(l);
            }
            finally {
                if (bl) {
                    this.rniMutex.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP getParentEnvironment(REXP rEXP, boolean bl) throws REngineException, REXPMismatchException {
        REXP rEXP2 = null;
        long l = 0L;
        if (rEXP != null && !rEXP.isReference()) {
            if (!rEXP.isEnvironment() || ((REXPEnvironment)rEXP).getHandle() == null) {
                throw new REXPMismatchException(rEXP, "environment");
            }
            l = ((JRIPointer)((REXPEnvironment)rEXP).getHandle()).pointer();
        } else if (rEXP != null) {
            l = (Long)((REXPReference)rEXP).getHandle();
        }
        boolean bl2 = this.rniMutex.safeLock();
        try {
            long l2 = this.rni.rniParentEnv(l);
            if (l2 == 0L || l2 == this.R_NilValue) {
                REXP rEXP3 = null;
                return rEXP3;
            }
            this.rni.rniPreserve(l2);
            rEXP2 = new REXPReference((REngine)this, new Long(l2));
            if (bl) {
                rEXP2 = this.resolveReference(rEXP2);
            }
        }
        finally {
            if (bl2) {
                this.rniMutex.unlock();
            }
        }
        return rEXP2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP newEnvironment(REXP rEXP, boolean bl) throws REXPMismatchException, REngineException {
        REXP rEXP2 = null;
        boolean bl2 = this.rniMutex.safeLock();
        try {
            long l;
            long l2 = 0L;
            if (rEXP != null && !rEXP.isReference()) {
                if (!rEXP.isEnvironment() || ((REXPEnvironment)rEXP).getHandle() == null) {
                    throw new REXPMismatchException(rEXP, "environment");
                }
                l2 = ((JRIPointer)((REXPEnvironment)rEXP).getHandle()).pointer();
            } else if (rEXP != null) {
                l2 = (Long)((REXPReference)rEXP).getHandle();
            }
            if (l2 == 0L) {
                l2 = (Long)this.globalEnv.getHandle();
            }
            if ((l = this.rni.rniEval(this.rni.rniLCons(this.rni.rniInstallSymbol("new.env"), this.rni.rniCons(l2, this.R_NilValue, this.rni.rniInstallSymbol("parent"), false)), 0L)) != 0L) {
                this.rni.rniPreserve(l);
            }
            rEXP2 = new REXPReference((REngine)this, new Long(l));
            if (bl) {
                rEXP2 = this.resolveReference(rEXP2);
            }
        }
        finally {
            if (bl2) {
                this.rniMutex.unlock();
            }
        }
        return rEXP2;
    }

    public boolean close() {
        if (this.rni == null) {
            return false;
        }
        this.rni.end();
        return true;
    }

    public synchronized int tryLock() {
        int n = this.rniMutex.tryLock();
        return n == 1 ? 0 : (n == -1 ? 2 : 1);
    }

    public synchronized int lock() {
        return this.rniMutex.safeLock() ? 1 : 2;
    }

    public synchronized void unlock(int n) {
        if (n == 1) {
            this.rniMutex.unlock();
        }
    }

    public boolean supportsReferences() {
        return true;
    }

    public boolean supportsEnvironments() {
        return true;
    }

    public boolean supportsLocking() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXPReference createRJavaRef(Object object) throws REngineException {
        if (object == null) {
            return null;
        }
        REXPReference rEXPReference = null;
        boolean bl = this.rniMutex.safeLock();
        try {
            org.rosuda.JRI.REXP rEXP = this.rni.createRJavaRef(object);
            if (rEXP == null) {
                throw new REngineException(this, "Could not push java Object to R");
            }
            long l = rEXP.xp;
            this.rni.rniPreserve(l);
            rEXPReference = new REXPReference((REngine)this, new Long(l));
        }
        finally {
            if (bl) {
                this.rniMutex.unlock();
            }
        }
        return rEXPReference;
    }

    public void rWriteConsole(Rengine rengine, String string, int n) {
        if (this.callbacks != null && this.callbacks instanceof REngineOutputInterface) {
            ((REngineOutputInterface)((Object)this.callbacks)).RWriteConsole(this, string, n);
        }
    }

    public void rBusy(Rengine rengine, int n) {
        if (this.callbacks != null && this.callbacks instanceof REngineUIInterface) {
            ((REngineUIInterface)((Object)this.callbacks)).RBusyState(this, n);
        }
    }

    public synchronized String rReadConsole(Rengine rengine, String string, int n) {
        if (this.callbacks != null && this.callbacks instanceof REngineInputInterface) {
            return ((REngineInputInterface)((Object)this.callbacks)).RReadConsole(this, string, n);
        }
        try {
            this.wait();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public void rShowMessage(Rengine rengine, String string) {
        if (this.callbacks != null && this.callbacks instanceof REngineOutputInterface) {
            ((REngineOutputInterface)((Object)this.callbacks)).RShowMessage(this, string);
        }
    }

    public String rChooseFile(Rengine rengine, int n) {
        if (this.callbacks != null && this.callbacks instanceof REngineUIInterface) {
            return ((REngineUIInterface)((Object)this.callbacks)).RChooseFile(this, n == 0);
        }
        return null;
    }

    public void rFlushConsole(Rengine rengine) {
        if (this.callbacks != null && this.callbacks instanceof REngineOutputInterface) {
            ((REngineOutputInterface)((Object)this.callbacks)).RFlushConsole(this);
        }
    }

    public void rSaveHistory(Rengine rengine, String string) {
        if (this.callbacks != null && this.callbacks instanceof REngineConsoleHistoryInterface) {
            ((REngineConsoleHistoryInterface)((Object)this.callbacks)).RSaveHistory(this, string);
        }
    }

    public void rLoadHistory(Rengine rengine, String string) {
        if (this.callbacks != null && this.callbacks instanceof REngineConsoleHistoryInterface) {
            ((REngineConsoleHistoryInterface)((Object)this.callbacks)).RLoadHistory(this, string);
        }
    }

    class JRIPointer {
        long ptr;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JRIPointer(long l, boolean bl) {
            this.ptr = l;
            if (bl && l != 0L && l != JRIEngine.this.R_NilValue) {
                boolean bl2 = JRIEngine.this.rniMutex.safeLock();
                try {
                    JRIEngine.this.rni.rniPreserve(l);
                }
                finally {
                    if (bl2) {
                        JRIEngine.this.rniMutex.unlock();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            block7: {
                try {
                    if (this.ptr == 0L || this.ptr == JRIEngine.this.R_NilValue) break block7;
                    boolean bl = JRIEngine.this.rniMutex.safeLock();
                    try {
                        JRIEngine.this.rni.rniRelease(this.ptr);
                    }
                    finally {
                        if (bl) {
                            JRIEngine.this.rniMutex.unlock();
                        }
                    }
                }
                finally {
                    super.finalize();
                }
            }
        }

        long pointer() {
            return this.ptr;
        }
    }
}

