/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.data;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import org.rosuda.deducer.data.ExTable;
import org.rosuda.deducer.data.RowNamesListModel;
import org.rosuda.ibase.Common;

public class ExScrollableTable
extends JScrollPane {
    private ExTable table;
    private RowNamesListModel rowNamesHeaderModel;
    private JList rowHeader;
    private static int widthMin = 40;
    private static int widthMax = 150;
    private static int widthMult = 8;
    private boolean displayContextualMenu;
    private RowListener rLis;

    public ExScrollableTable(ExTable exTable) {
        this.table = exTable;
        this.setViewportView(this.table);
        this.table.parentPane = this;
        this.rowNamesHeaderModel = new RowNamesListModel();
        this.rowNamesHeaderModel.initHeaders(this.table.getRowCount());
        this.rowHeader = new JList(this.rowNamesHeaderModel);
        this.rowHeader.setFixedCellWidth(Math.min(widthMax, Math.max(widthMin, this.rowNamesHeaderModel.getMaxNumChar() * widthMult + 10)));
        this.rowHeader.setFixedCellHeight(this.table.getRowHeight());
        this.rowHeader.setCellRenderer(new RowHeaderRenderer(this.table));
        this.setRowHeaderView(this.rowHeader);
        this.rLis = new RowListener();
        this.displayContextualMenu = true;
    }

    public ExTable getExTable() {
        return this.table;
    }

    public void displayContextualMenu(boolean bl) {
        this.displayContextualMenu = bl;
    }

    public RowNamesListModel getRowNamesModel() {
        return this.rowNamesHeaderModel;
    }

    public void setRowNamesModel(RowNamesListModel rowNamesListModel) {
        this.rowNamesHeaderModel = rowNamesListModel;
        this.rowHeader = new JList(this.rowNamesHeaderModel);
        this.rowHeader.setFixedCellWidth(Math.min(widthMax, Math.max(widthMin, this.rowNamesHeaderModel.getMaxNumChar() * widthMult + 10)));
        this.rowHeader.setFixedCellHeight(this.table.getRowHeight());
        this.rowHeader.setCellRenderer(new RowHeaderRenderer(this.table));
        this.setRowHeaderView(this.rowHeader);
        new RowListener();
    }

    public void autoAdjustRowWidth() {
        this.rowHeader.setFixedCellWidth(Math.min(widthMax, Math.max(widthMin, this.rowNamesHeaderModel.getMaxNumChar() * widthMult + 10)));
    }

    public void insertNewRow(int n) {
        this.table.insertNewRow(n);
        this.getRowNamesModel().refresh();
    }

    public void insertRow(int n) {
        if (this.table.getCopyPasteAdapter().getClipBoard().indexOf("\n") < this.table.getCopyPasteAdapter().getClipBoard().length() - 2 && this.table.getCopyPasteAdapter().getClipBoard().length() > 0) {
            JOptionPane.showMessageDialog(null, "The values in the clipboard do not seem to be a row.\nTry copying the desired data again.", "Invalid Row Insertion", 0);
            return;
        }
        this.insertNewRow(n);
        this.table.selectRow(n);
        this.table.requestFocus();
        this.table.getCopyPasteAdapter().paste();
    }

    public void removeRowListener() {
        this.rowHeader.removeMouseListener(this.rLis);
    }

    class RowContextMenu
    implements ActionListener {
        int index;
        private JPopupMenu menu;

        public RowContextMenu(MouseEvent mouseEvent, int n) {
            this.index = n;
            this.menu = new JPopupMenu();
            ExScrollableTable.this.table.getTableHeader().add(this.menu);
            JMenuItem jMenuItem = new JMenuItem("Copy");
            jMenuItem.addActionListener(this);
            this.menu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Cut");
            jMenuItem2.addActionListener(this);
            this.menu.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("Paste");
            jMenuItem3.addActionListener(this);
            this.menu.add(jMenuItem3);
            this.menu.addSeparator();
            JMenuItem jMenuItem4 = new JMenuItem("Insert");
            jMenuItem4.addActionListener(this);
            this.menu.add(jMenuItem4);
            JMenuItem jMenuItem5 = new JMenuItem("Insert New Row");
            jMenuItem5.addActionListener(this);
            this.menu.add(jMenuItem5);
            JMenuItem jMenuItem6 = new JMenuItem("Remove Row");
            jMenuItem6.addActionListener(this);
            this.menu.add(jMenuItem6);
            this.menu.addSeparator();
            JMenuItem jMenuItem7 = new JMenuItem("Edit Row Name");
            jMenuItem7.addActionListener(this);
            this.menu.add(jMenuItem7);
            this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem.getText() == "Copy") {
                ExScrollableTable.this.table.getCopyPasteAdapter().copy();
            } else if (jMenuItem.getText() == "Cut") {
                ExScrollableTable.this.table.cutRow(this.index);
            } else if (jMenuItem.getText() == "Paste") {
                ExScrollableTable.this.table.getCopyPasteAdapter().paste();
            } else if (jMenuItem.getText() == "Insert") {
                ExScrollableTable.this.insertRow(this.index);
            } else if (jMenuItem.getText() == "Insert New Row") {
                ExScrollableTable.this.insertNewRow(this.index);
            } else if (jMenuItem.getText() == "Remove Row") {
                ExScrollableTable.this.table.removeRow(this.index);
                ExScrollableTable.this.getRowNamesModel().refresh();
            } else if (jMenuItem.getText() == "Edit Row Name") {
                String string = ExScrollableTable.this.getRowNamesModel().getElementAt(this.index).toString();
                String string2 = JOptionPane.showInputDialog((JMenuItem)actionEvent.getSource(), "Edit row name:", string);
                if (string2 != null && string2.length() > 0) {
                    ExScrollableTable.this.getRowNamesModel().setElementAt(this.index, string2);
                }
            }
            this.menu.setVisible(false);
        }
    }

    class RowListener
    extends MouseAdapter {
        public RowListener() {
            ExScrollableTable.this.rowHeader.addMouseListener(this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3 && !Common.isMac()) {
                int n = ExScrollableTable.this.rowHeader.locationToIndex(mouseEvent.getPoint());
                ExScrollableTable.this.table.requestFocus();
                ExScrollableTable.this.table.selectRow(n);
                if (ExScrollableTable.this.displayContextualMenu) {
                    new RowContextMenu(mouseEvent, n);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = ExScrollableTable.this.rowHeader.locationToIndex(mouseEvent.getPoint());
            ExScrollableTable.this.table.requestFocus();
            ExScrollableTable.this.table.selectRow(n);
            if (mouseEvent.isPopupTrigger() && Common.isMac() && ExScrollableTable.this.displayContextualMenu) {
                new RowContextMenu(mouseEvent, n);
            }
        }
    }

    class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        RowHeaderRenderer(JTable jTable) {
            JTableHeader jTableHeader = jTable.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
            this.setFont(jTableHeader.getFont());
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(object == null ? "" : object.toString());
            return this;
        }
    }
}

