/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc.list;

import java.util.ArrayList;
import java.util.List;
import net.starschema.clouddb.jdbc.JdbcGrammarParser;
import net.starschema.clouddb.jdbc.antlr.sqlparse.ColumnCallException;
import net.starschema.clouddb.jdbc.antlr.sqlparse.TreeParsingException;
import net.starschema.clouddb.jdbc.list.Expression;
import net.starschema.clouddb.jdbc.list.FromExpression;
import net.starschema.clouddb.jdbc.list.FunctionCall;
import net.starschema.clouddb.jdbc.list.Node;
import net.starschema.clouddb.jdbc.list.SubQuery;
import net.starschema.clouddb.jdbc.list.SynonymContainer;
import net.starschema.clouddb.jdbc.list.TreeBuilder;
import net.starschema.clouddb.jdbc.list.UniQueIdContainer;
import org.antlr.runtime.tree.Tree;

public class ColumnCall
extends Node
implements UniQueIdContainer {
    private String name = null;
    private String[] prefixes = null;
    private List<String> aliases = null;
    String uniqueId = null;
    private UniQueIdContainer pointedNode = null;
    private List<UniQueIdContainer> extraPointedNodes = null;
    private boolean equivalentCol = false;
    Expression parentNode = null;
    private List<UniQueIdContainer> nodesPointingtoThis = null;
    TreeBuilder builder;
    FromExpression fromExpression = null;

    public List<UniQueIdContainer> getNodesPointingtoThis() {
        return this.nodesPointingtoThis;
    }

    public void addExtraPointedNode(UniQueIdContainer uniQueIdContainer) {
        if (this.extraPointedNodes == null) {
            this.extraPointedNodes = new ArrayList<UniQueIdContainer>();
        }
        this.extraPointedNodes.add(uniQueIdContainer);
        if (((Node)Node.class.cast((Object)uniQueIdContainer)).tokenType == 19) {
            ColumnCall columnCall = (ColumnCall)ColumnCall.class.cast(uniQueIdContainer);
            columnCall.addNodePointingToThis(this);
        }
    }

    public void setPointedNode(UniQueIdContainer pointedNode) {
        ColumnCall columnCall;
        if (this.pointedNode != null && this.pointedNode.getTokenType() == 19) {
            columnCall = (ColumnCall)ColumnCall.class.cast(this.pointedNode);
            columnCall.removeNodePointingToThis(this);
        }
        this.pointedNode = pointedNode;
        if (this.pointedNode != null && this.pointedNode.getTokenType() == 19) {
            columnCall = (ColumnCall)ColumnCall.class.cast(this.pointedNode);
            columnCall.addNodePointingToThis(this);
        }
    }

    public boolean isPointedTo() {
        return this.nodesPointingtoThis != null && this.nodesPointingtoThis.size() != 0;
    }

    public void addNodePointingToThis(UniQueIdContainer node) {
        if (node != null) {
            boolean found = false;
            for (UniQueIdContainer uniQueIdContainer : this.nodesPointingtoThis) {
                if (!node.getUniqueid().equals(uniQueIdContainer.getUniqueid())) continue;
                found = true;
                break;
            }
            if (!found) {
                this.nodesPointingtoThis.add(node);
            }
        }
    }

    public void removeNodePointingToThis(UniQueIdContainer node) {
        if (node != null) {
            boolean found = false;
            int i = 0;
            int location = 0;
            for (UniQueIdContainer uniQueIdContainer : this.nodesPointingtoThis) {
                if (node.getUniqueid().equals(uniQueIdContainer.getUniqueid())) {
                    found = true;
                    location = i;
                    break;
                }
                ++i;
            }
            if (found) {
                this.nodesPointingtoThis.remove(location);
            }
        }
    }

    public Expression getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(Expression parentNode) {
        this.parentNode = parentNode;
    }

    public boolean getEquivalentCol() {
        return this.equivalentCol;
    }

    public void setEquivalentCol(boolean equivalentCol) {
        this.equivalentCol = equivalentCol;
    }

    public List<String> getSynonyms() {
        ArrayList<String> returnList = new ArrayList<String>();
        if (this.getAlias() != null) {
            SubQuery parent = this.parentNode.selectStatement.parent;
            if (parent != null) {
                if (parent.getAlias() != null) {
                    returnList.add(parent.getAlias() + "." + this.getAlias());
                    returnList.add(this.getAlias());
                } else {
                    returnList.add(this.getAlias());
                }
            } else {
                returnList.add(this.getAlias());
            }
        } else if (this.pointedNode != null) {
            if (this.pointedNode.getTokenType() == 19) {
                SubQuery parent = this.parentNode.selectStatement.parent;
                ColumnCall columnCall = (ColumnCall)ColumnCall.class.cast(this.pointedNode);
                List<String> synonyms = columnCall.getSynonyms();
                if (synonyms != null) {
                    for (String string : synonyms) {
                        if (parent != null && parent.getAlias() != null) {
                            returnList.add(parent.getAlias() + "." + string);
                            returnList.add(string);
                            continue;
                        }
                        returnList.add(string);
                    }
                }
            } else if (this.pointedNode.getTokenType() == 53) {
                FunctionCall functionCall = (FunctionCall)FunctionCall.class.cast(this.pointedNode);
                SubQuery parent = this.parentNode.selectStatement.parent;
                if (this.getAlias() != null) {
                    if (parent != null) {
                        if (parent.getAlias() != null) {
                            returnList.add(parent.getAlias() + "." + this.getAlias());
                            returnList.add(this.getAlias());
                        }
                    } else {
                        returnList.add(this.getAlias());
                    }
                } else {
                    List<String> synonyms = functionCall.getSynonyms();
                    if (synonyms != null) {
                        for (String string : synonyms) {
                            if (parent != null) {
                                if (parent.getAlias() != null) {
                                    returnList.add(parent.getAlias() + "." + string);
                                    returnList.add(string);
                                    continue;
                                }
                                returnList.add(string);
                                continue;
                            }
                            returnList.add(string);
                        }
                    }
                }
            }
        } else {
            returnList.add(this.getWholeName());
            SubQuery parent = this.parentNode.selectStatement.parent;
            if (parent != null && parent.getAlias() != null) {
                returnList.add(parent.getAlias() + "." + this.getWholeName());
            }
        }
        if (returnList.size() != 0) {
            return returnList;
        }
        return null;
    }

    public ColumnCall(String[] prefixes, List<String> aliases, TreeBuilder builder, String name, Expression expression) {
        this.nodesPointingtoThis = new ArrayList<UniQueIdContainer>();
        this.name = name;
        this.parentNode = expression;
        this.prefixes = prefixes;
        this.aliases = aliases;
        this.builder = builder;
        this.uniqueId = builder.getuniqueid();
        this.tokenType = 19;
        this.tokenName = JdbcGrammarParser.tokenNames[19];
    }

    public ColumnCall(String[] prefixes, List<String> aliases, TreeBuilder builder, String name, UniQueIdContainer pointedNode, Expression parent) {
        this.parentNode = parent;
        if (pointedNode.getTokenType() == 19) {
            try {
                ColumnCall columnCall = (ColumnCall)ColumnCall.class.cast(pointedNode);
                if (columnCall.getEquivalentCol()) {
                    this.equivalentCol = true;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.name = name;
        this.prefixes = prefixes;
        this.aliases = aliases;
        this.builder = builder;
        this.uniqueId = builder.getuniqueid();
        this.tokenType = 19;
        this.tokenName = JdbcGrammarParser.tokenNames[19];
        this.nodesPointingtoThis = new ArrayList<UniQueIdContainer>();
        this.setPointedNode(pointedNode);
    }

    public ColumnCall(Tree t, TreeBuilder treeBuilder, FromExpression fromExpression, Expression parent) throws TreeParsingException {
        this.nodesPointingtoThis = new ArrayList<UniQueIdContainer>();
        this.parentNode = parent;
        this.builder = treeBuilder;
        this.uniqueId = this.builder.getuniqueid();
        this.fromExpression = fromExpression;
        this.build(t, this.builder);
    }

    public void addPrefixToEnd(String prefix) {
        if (this.prefixes == null) {
            this.prefixes = new String[]{prefix};
        } else {
            String[] temp = this.prefixes;
            this.prefixes = new String[this.prefixes.length + 1];
            int i = 0;
            String[] stringArray = temp;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String string;
                this.prefixes[i] = string = stringArray[j];
                ++i;
            }
            this.prefixes[this.prefixes.length - 1] = prefix;
        }
    }

    public void addPrefixtoFront(String prefix) {
        if (this.prefixes == null) {
            this.prefixes = new String[]{prefix};
        } else {
            String[] temp = this.prefixes;
            this.prefixes = new String[this.prefixes.length + 1];
            this.prefixes[0] = prefix;
            int i = 1;
            String[] stringArray = temp;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String string;
                this.prefixes[i] = string = stringArray[j];
                ++i;
            }
        }
    }

    public void build(Tree t, TreeBuilder builder) throws TreeParsingException {
        if (t.getType() == 19) {
            this.nodesPointingtoThis = new ArrayList<UniQueIdContainer>();
            this.tokenName = JdbcGrammarParser.tokenNames[t.getType()];
            this.tokenType = t.getType();
            this.logger.debug("BUILDING " + this.tokenName);
            ArrayList<String> scopeList = new ArrayList<String>();
            ArrayList<String> aliasList = new ArrayList<String>();
            block7: for (int i = 0; i < t.getChildCount(); ++i) {
                Tree child = t.getChild(i);
                switch (child.getType()) {
                    case 94: {
                        this.name = child.getChild(0).getText();
                        continue block7;
                    }
                    case 118: {
                        scopeList.add(child.getChild(0).getText());
                        continue block7;
                    }
                    case 5: {
                        aliasList.add(child.getChild(0).getText());
                        continue block7;
                    }
                }
            }
            if (aliasList.size() != 0) {
                this.aliases = aliasList;
            }
            if (scopeList.size() != 0) {
                this.prefixes = scopeList.toArray(new String[scopeList.size()]);
            }
            if (this.aliases == null) {
                String alias = "";
                if (this.prefixes != null) {
                    for (String string : scopeList) {
                        alias = alias + string + ".";
                    }
                    final String alias2 = alias = alias + this.name;
                    this.aliases = new ArrayList<String>(){
                        {
                            this.add(alias2);
                        }
                    };
                }
            }
            this.logger.debug("CALLING SEARCH");
            try {
                List<UniQueIdContainer> pointedNodesInFromExpression = this.searchPointedNodeInFromExpression(this.fromExpression);
                if (pointedNodesInFromExpression == null) {
                    List<String> possiblePrefixes = builder.getPossiblePrefixes(this.name);
                    for (int i = 0; i < possiblePrefixes.size() && pointedNodesInFromExpression == null; ++i) {
                        if (possiblePrefixes.get(i) != null) {
                            this.logger.debug("Possible prefix for the column: " + this.name + "is:" + possiblePrefixes.get(i).toString());
                            String prefixString = possiblePrefixes.get(i);
                            this.prefixes = new String[1];
                            this.prefixes[0] = prefixString;
                            pointedNodesInFromExpression = this.searchPointedNodeInFromExpression(this.fromExpression);
                            continue;
                        }
                        this.logger.debug("Possible prefix for the column: " + this.name + "is NULL");
                    }
                }
                this.setPointedNode(pointedNodesInFromExpression.get(0));
                for (UniQueIdContainer uniQueIdContainer : pointedNodesInFromExpression) {
                    this.addExtraPointedNode(uniQueIdContainer);
                }
            }
            catch (ColumnCallException e) {
                throw new TreeParsingException(e);
            }
        } else {
            throw new TreeParsingException(19, t.getType());
        }
    }

    public String getAlias() {
        String forReturn = "";
        if (this.aliases == null) {
            return null;
        }
        for (String iter : this.aliases) {
            forReturn = forReturn + iter + "_";
        }
        return forReturn.substring(0, forReturn.length() - 1);
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public String getName() {
        return this.name;
    }

    public Node getPointedNode() {
        return (Node)((Object)this.pointedNode);
    }

    public String[] getScopes() {
        return this.prefixes;
    }

    public String getWholeName() {
        String name = "";
        if (this.getScopes() != null) {
            for (String scope : this.getScopes()) {
                name = name + scope + ".";
            }
        }
        name = name + this.getName();
        return name;
    }

    public void removePrefix(String prefix) {
        int i;
        if (this.prefixes == null) {
            return;
        }
        boolean removed = false;
        for (i = 0; !removed && i < this.prefixes.length; ++i) {
            if (!this.prefixes[i].equals(prefix)) continue;
            this.prefixes[i] = null;
            removed = true;
        }
        if (removed) {
            String[] newPrefixes = new String[this.prefixes.length - 1];
            i = 0;
            for (String string : this.prefixes) {
                if (string == null) continue;
                newPrefixes[i] = string;
                ++i;
            }
            this.prefixes = newPrefixes;
            this.logger.debug("Removed prefix " + prefix);
        }
    }

    private List<UniQueIdContainer> searchPointedNodeInFromExpression(FromExpression fromExpression) throws ColumnCallException {
        this.logger.debug("IN SEARCH");
        List<SubQuery> subQueries = fromExpression.getSubQueries();
        if (subQueries != null) {
            ArrayList<UniQueIdContainer> validPointedNodes = new ArrayList<UniQueIdContainer>();
            for (SubQuery subQuery : subQueries) {
                List<SynonymContainer> availableResources = subQuery.getAvailableResources();
                for (SynonymContainer synonymContainer : availableResources) {
                    List<String> synonyms = synonymContainer.getSynonyms();
                    for (String string : synonyms) {
                        if (string == null || !string.equals(this.getWholeName())) continue;
                        this.logger.debug("ADDING NODE");
                        validPointedNodes.add(synonymContainer.getPointedResource());
                    }
                }
            }
            if (validPointedNodes.size() > 1) {
                boolean sameUniqueId = true;
                String uniqueId = ((UniQueIdContainer)validPointedNodes.get(0)).getUniqueid();
                for (UniQueIdContainer uniQueIdContainer : validPointedNodes) {
                    if (uniQueIdContainer.getUniqueid().equals(uniqueId)) continue;
                    sameUniqueId = false;
                }
                if (!sameUniqueId) {
                    throw new ColumnCallException("AMBIGOUS COLUMNCALL: " + this.getName());
                }
                return validPointedNodes;
            }
            if (validPointedNodes.size() == 1) {
                return validPointedNodes;
            }
            return null;
        }
        return null;
    }

    @Override
    public String toPrettyString() {
        return this.toPrettyString(-1);
    }

    @Override
    public String toPrettyString(int level) {
        if (this.getPointedNode() != null) {
            if (this.getPointedNode().tokenType == 19) {
                return ((ColumnCall)ColumnCall.class.cast((Object)this.getPointedNode())).uniqueId + " AS " + this.uniqueId;
            }
            return ((FunctionCall)FunctionCall.class.cast((Object)this.getPointedNode())).uniqueId + " AS " + this.uniqueId;
        }
        return this.getName() + " AS " + this.uniqueId;
    }

    @Override
    public String getUniqueid() {
        return this.uniqueId;
    }
}

