% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r
\name{plotDataExplorer}
\alias{plotDataExplorer}
\title{Default DataExplorer plotting function}
\usage{
plotDataExplorer(plot_obj, title, ggtheme, theme_config, ...)
}
\arguments{
\item{plot_obj}{plot object}

\item{title}{plot title}

\item{ggtheme}{complete ggplot2 themes}

\item{theme_config}{a list of configurations to be passed to \link{theme}}

\item{\dots}{other arguments to be passed}
}
\value{
invisibly return the named list of ggplot objects
}
\description{
S3 method for plotting various DataExplorer objects
}
\details{
To change default font family and size, you may pass \code{base_size} and \code{base_family} to \code{ggtheme} options, e.g., \code{ggtheme = theme_gray(base_size = 15, base_family = "serif")}

\code{theme_config} argument expects all inputs to be wrapped in a list object, e.g., to change the text color: \code{theme_config = list("text" = element_text(color = "blue"))}
}
\examples{
library(ggplot2)
# Update theme of any plot objects
plot_missing(airquality, ggtheme = theme_light())
plot_missing(airquality, ggtheme = theme_minimal(base_size = 20))

# Customized theme components
plot_bar(
  data = diamonds,
  theme_config = list(
  "plot.background" = element_rect(fill = "yellow"),
  "aspect.ratio" = 1
  )
)
}
\seealso{
\link{plotDataExplorer.grid} \link{plotDataExplorer.single} \link{plotDataExplorer.multiple}
}
\keyword{internal}
