% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_histogram.r
\name{plot_histogram}
\alias{plot_histogram}
\title{Plot histogram}
\usage{
plot_histogram(data, geom_histogram_args = list(), title = NULL,
  ggtheme = theme_gray(), theme_config = list(), nrow = 4L,
  ncol = 4L, parallel = FALSE)
}
\arguments{
\item{data}{input data}

\item{geom_histogram_args}{a list of other arguments to \link{geom_histogram}}

\item{title}{plot title}

\item{ggtheme}{complete ggplot2 themes. The default is \link{theme_gray}.}

\item{theme_config}{a list of configurations to be passed to \link{theme}.}

\item{nrow}{number of rows per page. Default is 4.}

\item{ncol}{number of columns per page. Default is 4.}

\item{parallel}{enable parallel? Default is \code{FALSE}.}
}
\value{
invisibly return the named list of ggplot objects
}
\description{
Plot histogram for each continuous feature
}
\examples{
# Plot iris data
plot_histogram(iris)

# Plot random data with customized geom_histogram settings
set.seed(1)
data <- cbind(sapply(seq.int(4L), function(x) {rnorm(1000, sd = 30 * x)}))
plot_histogram(data, geom_histogram_args = list("breaks" = seq(-400, 400, length = 50)))
}
\seealso{
\link{geom_histogram} \link{plot_density}
}
\keyword{plot_histogram}
