% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BarDiscrete.r
\name{BarDiscrete}
\alias{BarDiscrete}
\title{Create bar charts for discrete features}
\usage{
BarDiscrete(data, na.rm = TRUE, maxcat = 50)
}
\arguments{
\item{data}{input data to be plotted, in either \link{data.frame} or \link{data.table} format.}

\item{na.rm}{logical, indicating if missing values should be removed for each feature. The default is \code{TRUE}.}

\item{maxcat}{maximum categories allowed for each feature. The default is 50. More information in 'Details' section.}
}
\description{
This function creates frequency bar charts for each discrete feature.
}
\details{
If a discrete feature contains more categories than \code{maxcat} specifies, it will not be passed to the plotting function. Instead, it will be passed to \code{cat} with number of categories.
}
\examples{
# load packages
library(ggplot2)
library(data.table)

# load diamonds dataset from ggplot2
data("diamonds")

# plot bar charts for diamonds dataset
BarDiscrete(diamonds)
BarDiscrete(diamonds, maxcat = 5)
}
\keyword{bardiscrete}

