% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chp4.R
\name{binom2pois}
\alias{binom2pois}
\title{Binomial Approaching Poisson}
\usage{
binom2pois(x, lambda, size = c(10L, 100L))
}
\arguments{
\item{x}{\link[base]{integer} scalar}

\item{lambda}{positive \link[base]{numeric} scalar}

\item{size}{\link[base]{integer} vector}
}
\value{
\link{binom2pois} returns a \link{binom2pois} object, for which 
a \link[base]{print} method, a \link[ggplot2]{autolayer} and a \link[ggplot2]{autoplot} method are defined.
}
\description{
Binomial Approaching Poisson
}
\details{
\link{binom2pois} shows how binomial distribution approaches Poisson distribution when
\eqn{n\rightarrow\infty} and \eqn{p\rightarrow 0}, while holding a constant product \eqn{np=\lambda}.
}
\examples{
binom2pois(x = 4L, lambda = 6, size = seq.int(10L, 50L, by = 10L))

}
\seealso{
\link[stats]{dbinom} \link[stats]{dpois}
}
