% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_casupro_eco.R
\name{write_casupro_eco}
\alias{write_casupro_eco}
\title{Writes parameters to a single DSSAT CASUPRO ecotype parameter file (*.ECO)}
\usage{
write_casupro_eco(eco)
}
\description{
Writes parameters to a single DSSAT CASUPRO ecotype parameter file (*.ECO)
}
\examples{

sample_eco <- c('CA0001  (CP 80-1743; CP 88-1762)',
'!-------------------',
'  KCAN_ECO      0.80    Superseeds KCAN from .SPE file',
'  SMAX            20    Maximum number of stalks a variety can yield per stubble or plan',
'!-------------------',
'  CAB              8    Number of leaves in spindle cluster at top of stalk ("cabbage").',
'  CanLmtFac    0.010    Proportion of stalk leaf area moved up each day to keep de-popul',
'  LfShdFac      0.35    Proportion of a stalks new leaf area that shades (displaces to ',
'  MINSHD        0.15    Minimum value allowed for FRSHAV (Average of daylight fraction o',
'!-------------------',
'  StkSenFrac  .00005    Threshold maintenance respiration deficit to stalk dry weight ra',
'  SENDAY        0.05    Maximum fraction of existing leaf weight which can be senesced o')

eco <- read_casupro_eco(sample_eco)

write_casupro_eco(eco)

}
\keyword{internal}
