% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datetime_restrictions.R
\name{apply_time_restriciton}
\alias{apply_time_restriciton}
\title{Time filtering of data.table or sql-strings.}
\usage{
apply_time_restriciton(
  data,
  key,
  lower_limit,
  upper_limit,
  system_name = NULL,
  system_type,
  mdr,
  logfile_dir = NULL,
  db_con = NULL,
  sql_create_view_all = list()
)
}
\arguments{
\item{data}{If system_type is a database, the sql-string goes here.
If system_type is 'csv', the data.table of this csv goes here.}

\item{key}{The key from the mdr.}

\item{lower_limit}{The posixct timestamp of the lower filtering boundary.}

\item{upper_limit}{The posixct timestamp of the upper filtering boundary.}

\item{system_name}{(Optional for non-database-changes)
'i2b2'/'p21csv'/'omop'/...}

\item{system_type}{'postgres'/'oracle'/'csv'}

\item{mdr}{(Optional for non-database-changes) The internal MDR
(get it from `rv$mdr`)}

\item{logfile_dir}{(Optional) The directory to store the logfile in.
Defaults to NULL.}

\item{db_con}{(Optional for non-database-changes) The connection to the
database. Used to create the views we need later to apply the SQLs to.}

\item{sql_create_view_all}{(Optional, list). A list containing the SQLs to
create all Views for the time-filtering. This is needed for the
printing-friendly SQL including this view-creating SQLs and the actual
data-extracting SQL query.}
}
\value{
If system_type is a database, a list with the new sql-string
  containing the temporal filtering will be returned under $sql
 ('order by' parts will be removed) and a printable sql containing the
 commands to create the view needed to run the sql under $sql_extended.
 If system_type is 'csv', the filtered data.table will be returned.
}
\description{
Internal function to filter the input data (or SQL) depending
  on provided time information. Sensitive to SQL dialects.
}
