% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimatePD.R
\name{estimatePD}
\alias{estimatePD}
\title{Estimate the drop-out probability based on number of alleles}
\usage{
estimatePD(n0, m, pnoa = NULL, probs = NULL, theta = 0, locuswise = FALSE)
}
\arguments{
\item{n0}{Vector of observed allele counts - same length as the number of
loci}

\item{m}{The number of contributors}

\item{pnoa}{The vector of \eqn{\P(N(m)=n)}{Pr(N(m)=n)} for \eqn{n=1,\ldots,2Lm}, where \eqn{L} is the number
of loci and \eqn{m} is the number of contributors OR}

\item{probs}{List of vectors with allele probabilities for each locus}

\item{theta}{The coancestery coefficient}

\item{locuswise}{Logical. Indicating whether computations should be done
locuswise.}
}
\value{
Returns the MLE of \eqn{\Pr(D)}{Pr(D)} based on equation (10) in Tvedebrink (2014)
}
\description{
An inferior may to estimate the drop-out probability compared to using the
peak heights from the electropherogram. However, to compare the performance
with Gill et al. (2007) this implements a theoretical approach based on
their line of arguments.
}
\details{
Computes the \eqn{\Pr(D)}{Pr(D)} that maximises equation (10) in Tvedebrink (2014).
}
\examples{

  ## Simulate some allele frequencies:
  freqs <-  simAlleleFreqs()
  ## Assume 15 alleles are observed in a 2-person DNA mixture with 10 loci:
  estimatePD(n0 = 15, m = 2, probs = freqs)

}
\references{
Gill, P., A. Kirkham, and J. Curran (2007).  LoComatioN: A
software tool for the analysis of low copy number DNA profiles.  Forensic
Science International 166(2-3): 128 - 138.

T. Tvedebrink (2014). 'On the exact distribution of the number of 
alleles in DNA mixtures', International Journal of Legal Medicine; 128(3):427--37. 
<https://doi.org/10.1007/s00414-013-0951-3>
}
\author{
Torben Tvedebrink
}
