% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.gic.DMR.R
\name{predict.gic.DMR}
\alias{predict.gic.DMR}
\title{predict.gic.DMR}
\usage{
\method{predict}{gic.DMR}(object, newx, type = "link", ...)
}
\arguments{
\item{object}{Fitted gic.DMR object.}

\item{newx}{Data frame of new values for X at which predictions are to be made.}

\item{type}{One of: link, response, class. For "gaussian" for all values of type it gives the fitted values. For "binomial" type "link" gives the linear predictors, for type "response" it gives the fitted probabilities and for type "class" it produces  the  class  label  corresponding  to  the  maximum  probability.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Vector of predictions.
}
\description{
Make predictions from a gic.DMR object (for the model with minimal gic).
}
\details{
Similar to other predict methods, this function predicts fitted values from a fitted gic.DMR object for the model with minimal gic.
}
\examples{
data(miete)
ytr <- miete[1:1500,1]
Xtr <- miete[1:1500,-1]
Xte <- miete[1501:2053,-1]
m <- DMR(Xtr, ytr)
g <- gic.DMR(m, c = 2.5)
ypr <- predict(g, newx = Xte)
}

