% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StochasticSRA.R
\name{compplot}
\alias{compplot}
\title{Generic comparison plot for simulation testing of Stochastic SRA method}
\usage{
compplot(simy, samy, xlab = "", ylab = "", maxplot = 10, type = "l")
}
\arguments{
\item{simy}{The simulated time series}

\item{samy}{The matrix of estimated time series from of StochasticSRA() function.}

\item{xlab}{The x axis label for the plot}

\item{ylab}{The y axis label for the plot}

\item{maxplot}{The total number of individual simulations to be plotted in the first plot}

\item{type}{Should a line 'l' or points 'p' be plotted?}
}
\value{
A plot
}
\description{
Plots simulation variables versus estimation variables for Stochastic SRA methods of conditioning operating models.
}
\examples{
nyears<-100
nsims<-200
simy<-sin(seq(0,2,length.out=nyears))
samy<-array(rep(simy,each=nsims)*rnorm(nsims,1,0.2)*rnorm(nsims*nyears,1,0.1),c(nsims,nyears))
par(mfrow=c(1,2))
compplot(simy,samy,xlab="Year",ylab="Some time varying parameter")
}
\author{
T. Carruthers (Canadian DFO grant)
}
