% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefineClasses.r
\docType{class}
\name{MSE-class}
\alias{MSE-class}
\title{Class \code{'MSE'}}
\description{
A Management Strategy Evaluation object that contains information about
simulation conditions and performance of data-limited methods
}
\section{Slots}{

\describe{
\item{\code{Name}}{Name of the MSE object. Single value. Character string}

\item{\code{nyears}}{The number of years for the historical simulation. Single value. Positive integer}

\item{\code{proyears}}{The number of years for the projections - closed loop simulations. Single value. Positive integer}

\item{\code{nMPs}}{Number of management procedures simulation tested. Single value. Positive integer.}

\item{\code{MPs}}{The names of the MPs that were tested. Vector of length nMPs. Character strings.}

\item{\code{nsim}}{Number of simulations. Single value. Positive integer}

\item{\code{OM}}{A table of sampled parameter of the operating model. Table object of nsim rows. Real numbers\cr
 \itemize{
 \item RefY: reference yield, the highest long-term yield (mean over last five years of projection) obtained from a fixed F strategy. This is a useful reference point for framing performance of MPs because it standardizes for starting point and future productivity. 
 \item M: instantaneous natural mortality rate
 \item Depletion: stock depletion (biomass / unfished biomass) in the final historical year (prior to projection)
 \item A: abundance (biomass) updated in each management update of projection
 \item BMSY_B0: most productive stock size relative to unfished
 \item FMSY_M: fishing mortality rate divided by natural mortality rate
 \item Mgrad: mean average percentage gradient in natural mortality rate (percentage per time step)
 \item Msd: interannual variability in natural mortality rate (lognormal CV)
 \item procsd: process error - CV in log-normal recruitment deviations
 \item Esd: interannual variability in historical effort (fishing mortality rate)
 \item dFfinal: gradient in fishing mortality rate over final five years of the historical simulation
 \item MSY: Maximum Sustainable Yield
 \item qinc: mean percentage increase in fishing efficiency (catchability) in projected years (input controls only)
 \item qcv: interannual variability in future fishing efficiency (catchability) in projected years (input controls only)
 \item FMSY: Fishing mortality rate at Maximum Sustainable Yield
 \item Linf: maximum length (von Bertalanffy Linf parameter)
 \item K: maximum growth rate (von Bertalanffy K parameter)
 \item t0: theoretical length at age zero (von Bertalanffy t0 parameter)
 \item hs: steepness of the stock recruitment relationship (the fraction of unfished recruitment at a fifth of unfished stock levels)
 \item Linfgrad: mean gradient in maximum length (per cent per time step)
 \item Kgrad: mean gradient in maximum growth rate (per cent per time step)
 \item Linfsd: interannual variability in maximum length (log normal CV)
 \item Ksd: interannual variability in maximum growth rate (log normal CV)
 \item ageM: age at 50 per cent maturity
 \item LFS: length at full selection (the shortest length class where fishery selectivity is 100 per cent)
 \item age05: the age at 5 percent selectivity (ascending limb of selectivity curve)
 \item Vmaxage: the selectivity of the oldest age class (controls dome shape of selectivity curve)
 \item LFC: length at first capture, the smallest length that can be caught by the gear
 \item OFLreal: the true simulated Over Fishing Limit (FMSY x biomass) updated in each management update of the projection
 \item Spat_targ: spatial targetting parameter, fishing mortality rate across areas is proportional to vulnerable biomass raised to the power of this number. 
 \item Size_area_1: The size of area 1 relative to area 2
 \item Frac_area_1: the fraction of unfished biomass inhabiting area 1 (can be seen as fraction of habitat in area 1 or relative size of area 1)
 \item Prob_staying: the probability that individuals in area 1 remain there between time-steps
 \item AC: autocorrelation in recruitment
}}

\item{\code{Obs}}{A table of sampled parameters of the observation model. Table of nsim rows. Real numbers\cr
\itemize{
\item Cbias: bias in observed catches
\item Csd: observation error in observed catches (lognormal CV)
\item CAA_nsamp: the number of catch-at-age observations per time step
\item CAA_ESS: the effective sample size of multinomial catch-at-age observation model (number of independent draws)
\item CAL_nsamp: the number of catch-at-length observations per time step
\item CAL_ESS: the effective sample size of multinomial catch-at-length observation model (number of independent draws)
\item Isd: observation error in relative abundance index (lognormal CV)
\item Dbias: bias in observed stock depletion (also applies to depletion Dt for DCAC)
\item Mbias: bias in observed natural mortality rate
\item FMSY_Mbias: bias in ratio of FMSY to natural mortality rate
\item BMSY_B0bias: bias in ratio of most productive stock size relative to unfished
\item AMbias: bias in age at 50 per cent maturity
\item LFCbias: bias in length at first capture
\item LFSbias: bias in length at full selection
\item Abias: bias in observed current absolute stock biomass
\item Kbias: bias in maximum growth rate (von Bertalanffy K parameter)
\item t0bias: bias in theoretical length at age zero (von Bertalanffy t0 parameter)
\item Linfbias: bias in maximum length (von Bertalanffy Linf parameter)
\item hbias: bias in observed steepness of the stock recruitment relationship
\item Irefbias: bias in abundance index corresponding to BMSY stock levels
\item Crefbias: bias in MSY prediction (target or reference catch)
\item Brefbias: bias in BMSY stock levels (target or reference biomass levels)}}

\item{\code{B_BMSY}}{Simulated biomass relative to BMSY over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{F_FMSY}}{Simulated fishing mortality rate relative to FMSY over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{B}}{Simulated stock biomass over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{SSB}}{Simulated spawning stock biomass over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{VB}}{Simulated vulnerable biomass over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{FM}}{Simulated fishing mortality rate over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{C}}{Simulated catches (taken) over the projection. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{TAC}}{Simulated Total Allowable Catch (prescribed) over the projection (this is NA for input controls). An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{SSB_hist}}{Simulated historical spawning stock biomass. An array with dimensions: nsim, nages, nMPs, proyears. Non-negative real numbers}

\item{\code{CB_hist}}{Simulated historical catches in weight. An array with dimensions: nsim, nages, nMPs, proyears. Non-negative real numbers}

\item{\code{FM_hist}}{Simulated historical fishing mortality rate. An array with dimensions: nsim, nages, nMPs, proyears. Non-negative real numbers}

\item{\code{Effort}}{Simulated relative fishing effort in the projection years. An array with dimensions: nsim, nMPs, proyears. Non-negative real numbers}

\item{\code{PAA}}{Population at age in last projection year. An array with dimensions: nsim, nMPs, nages. Non-negative real numbers}

\item{\code{CAA}}{Catch at age in last projection year. An array with dimensions: nsim, nMPs, nages. Non-negative real numbers}

\item{\code{CAL}}{Catch at length in last projection year. An array with dimensions: nsim, nMPs, nCALbins. Non-negative real numbers}

\item{\code{CALbins}}{Mid-points of the catch-at-length bins. Vector of length nCALbins. Positive real numbers.}
}}

\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new('MSE', Name, nyears, proyears, nMPs, MPs, nsim, OMtable, Obs,
B_BMSYa, F_FMSYa, Ba, FMa, Ca, OFLa, Effort, PAA, CAA, CAL, CALbins)}
}

\author{
T. Carruthers
}
\keyword{classes}
