% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AVGM.R
\name{AVGM}
\alias{AVGM}
\title{Averaged Generalized Method of Moments Imputation (AVGM)}
\usage{
AVGM(data, M, midx = 1)
}
\arguments{
\item{data}{A data frame where the first column is the response variable (Y), and others are predictors (X).}

\item{M}{Number of multiple imputations.}

\item{midx}{Integer indicating which column is the response variable (default = 1).}
}
\value{
A list containing:
  \item{betahat}{Final averaged regression coefficient estimates.}
  \item{Yhat}{Imputed response variable with all missing values filled in.}
  \item{comm}{Completion flag (1 = success).}
}
\description{
This function performs multiple imputations on missing values in the response variable Y,
using AVGMMI logic with support for grouped data. It is fully self-contained.
}
\examples{
set.seed(123)
data <- data.frame(
  y = c(rnorm(50), rep(NA, 10)),
  x1 = rnorm(60),
  x2 = rnorm(60)
)
result <- AVGM(data, M = 10)
head(result$Yhat)
}
