% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddcorGO.R
\name{ddcorFindSignificant}
\alias{ddcorFindSignificant}
\title{Find groups of differentially correlated gene symbols.}
\usage{
ddcorFindSignificant(ddcor_res, pval_gene_thresh = 0.05, adjusted = FALSE,
  classes = FALSE, geneNameCol = c("Gene1", "Gene2"),
  unique_genes = FALSE, regcor = FALSE)
}
\arguments{
\item{ddcor_res}{The table of differential correlations outputted from ddcor. Expected to have pValDiff or pValDiff_adj columns as well as zScoreDiff, Gene1, +/- Classes columns.}

\item{pval_gene_thresh}{p-value threshold to call a gene as having significant differential correlation or not. Default = 0.05}

\item{adjusted}{Logical indicating whether adjusted p-values from the differential correlation table (i.e., column "pValDiff_adj", when adjusted = TRUE) or unadjusted p-values (i.e., column "pValDiff", when adjusted = FALSE) should be used to subset the table into significant and non-significant portions. Default = FALSE}

\item{classes}{Logical indicator specifying whether individual differential correlation gene classes should be extracted from the table or not. If not, only the zScoreDiff column is used to specify positively or negatively differentially correlated genes between the two conditions. Default = FALSE}

\item{geneNameCol}{Character vector specifying the name of the columns that are used to extract the gene symbols. Note that the default is c("Gene1", "Gene2"), but this only makes sense in the context of a full DGCA experiment. In the case of a splitSet, you may want to use "Gene1" to avoid counting the splitSet names in all of the categories.}

\item{unique_genes}{Logical, if TRUE indicates that unique gene symbols from each category compared to the other groups should be chosen prior to GO enrichment analysis.}

\item{regcor}{Logical specifying whether the ddcorGO analysis should be performed on the results of a regcor data analysis. Note that the classes option is not available in this case.}
}
\value{
A list of significantly differentially correlated genes.
}
\description{
Takes a table of differentially correlated genes with respect to one gene in the Gene2 column and returns the a list of vectors with unique, non-NA gene symbols for genes in each of the differentially correlated classes.
}

