# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Deconvolute mixed haplotypes
#'
#' @description Deconvolute mixed haplotypes, and reporting the mixture proportions from each sample
#' This function provieds an interface for calling \emph{dEploid} from R.
#' The command line options are passed via the \code{args} argument
#'
#' @section Seeding:
#' The R version of DEploid uses random number from R's random generator. Therefore, the '-seed'
#' argument of the command line version will be ignored, and no seed is given in the output. Use
#' the R function 'set.seed' prior to calling this function to ensure reproduciblity of results.
#'
#' @param args String of dEploid input.
#'
#' @seealso
#' \itemize{
#'   \item \code{vignette('dEploid-Arguments')} for an overview of commandline arguments
#' }
#'
#' @return A list with members of haplotypes, proportions and log likelihood of the MCMC chain.
#' \itemize{
#'   \item \code{Haps} Haplotypes at the final iteration in plain text file.
#'   \item \code{Proportions} MCMC updates of the proportion estimates.
#'   \item \code{llks} Log likelihood of the MCMC chain.
#' }
#'
#' @export
#'
#' @examples
#' vcfFile = system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
#' plafFile = system.file("extdata", "labStrains.test.PLAF.txt", package = "DEploid")
#' set.seed(1234)
#' PG0390.deconv = dEploid(paste("-vcf", vcfFile, "-plaf", plafFile, "-noPanel"))
#'
dEploid <- function(args) {
    .Call('DEploid_dEploid', PACKAGE = 'DEploid', args)
}

test_RRG_sample <- function() {
    .Call('DEploid_test_RRG_sample', PACKAGE = 'DEploid')
}

test_RRG_sampleUnitExpo <- function() {
    .Call('DEploid_test_RRG_sampleUnitExpo', PACKAGE = 'DEploid')
}

test_RRG_sampleExpoExpoLimit <- function(lambda, b, limit) {
    .Call('DEploid_test_RRG_sampleExpoExpoLimit', PACKAGE = 'DEploid', lambda, b, limit)
}

