% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detcurve.R
\name{detc.CI}
\alias{detc.CI}
\title{DET Curve calculation with Confidence Interval}
\usage{
detc.CI(responses, predictors, conf = 0.95, names = c(""),
  positive = "", title = "", legend = "topright", parallel = FALSE,
  ncores = 2, file, plotROC = FALSE, xlim = c(0.05, 50),
  ylim = c(0.05, 50), col = c("black", "blue", "red", "green",
  "yellow"), colbands = c("lightgray", "lightblue", "lightpink",
  "lightgreen", "lightyellow"))
}
\arguments{
\item{responses}{A dataframe of factor, numeric or character vector of responses, typically encoded with 0 (non-target) and 1 (target).  By default, the first two values of levels(as.factor(response)) are taken. If only one response is passed, 
it will be used for calculating all the curves.}

\item{predictors}{A dataframe of numeric vector of the same length than response, containing the predicted value of each observation. An ordered factor is coerced to a numeric.}

\item{conf}{The width of the confidence interval as [0,1]. Default: 0.95 (95\% CI).}

\item{names}{Array of strings, containing the name of each pair (response,predictor) that will appear in the legend of the graph.}

\item{positive}{string with the name of the 'positive' class. Default: negative class will be the first string of response levels and positive class the second string.}

\item{title}{Main tile for the graph}

\item{legend}{the location of the leyend in the graph. Could be a single keyword from the list "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right", "center" and NULL. Default: "topright".}

\item{parallel}{if TRUE, the bootstrap is processed in parallel, using parallel backend provided by plyr (foreach).}

\item{ncores}{The number of nodes to be forked for the parallel computation. Default: 2.}

\item{file}{The name of the file where the plot will be saved . If Empty, the DET and ROC curves are plotted by the graphic output.}

\item{plotROC}{Boolean specifying ploting or not the ROC Curve}

\item{xlim}{numeric vector of length 2, giving the x coordinates range.}

\item{ylim}{numeric vector of length 2, giving the y coordinates range.}

\item{col}{Array indicating a specification for the plotting color for DET curve of each classifier.}

\item{colbands}{Array indicating a specification for the plotting color for DET CI bands of each classifier.}
}
\value{
A list of dataframe, one per classifier. Each dataframe contains the name of the pair, and the 
parameters of the DET curve (FPR, the median of FNR and the upper and lower extremes for the CI, and the thresholds used), along with the confidence interval for the Equal Error Rate .
}
\description{
From a dataframe of responses and predictors, the function calculates and plots DET curves for each pair (response,predictor), with a Confidence Interval. In addition, ROC curves can be displayed by activating a boolean argument.
}
\examples{
\donttest{
n <- 500
#Predictors with normal distribution
set.seed(1235)
scoreNegative <- rnorm(n, mean = 0.25,sd = 0.125) 
set.seed(11452)
scorePositive1 <- rnorm(n, mean = 0.55,sd = 0.125)
set.seed(54321)
scorePositive2 <- rnorm(n, mean = 0.65,sd = 0.125)
response = c(rep(c("target"), times = n),rep(c("nontarget"), times = n))
predictor1 = c(scoreNegative,scorePositive1)
predictor2 = c(scoreNegative,scorePositive2)
responses <- data.frame(
  response = response
)
predictors <- data.frame(
  DET1 = predictor1,
  DET2 = predictor2
)
#Run in parallel for a faster execution (takes about 3-5 min in a 2018 laptop) activating 
#logical argument 'parallel'
detcurve <- detc.CI(responses,predictors, 
                   names = names(predictors),
                   title = "Example with CI",
                   positive="target",
                   parallel = TRUE)
#If you want to plot the EER and its CI on the curves:
for (name in names(detcurve)){
    points(qnorm(detcurve[[name]]$EER_median),qnorm(detcurve[[name]]$EER_median),
           pch=19,col = detcurve[[name]]$color,lwd=2.5)
    points(qnorm(detcurve[[name]]$EER_lower),qnorm(detcurve[[name]]$EER_lower),
           pch=20,col = detcurve[[name]]$color,lwd=2.5)
    points(qnorm(detcurve[[name]]$EER_upper),qnorm(detcurve[[name]]$EER_upper),
           pch=20,col = detcurve[[name]]$color,lwd=2.5)
}
}
}
