\name{gearyc.boot}

\alias{gearyc.boot}
\alias{gearyc.pboot}

\title{Generate bootstrap replicates of Moran's I autocorrelation statistic}


\description{
Generate bootstrap replicates of Moran's I autocorrelation statistic, by means
of function \emph{boot} form \emph{boot} library. Notice that these functions
should not  be used separately but as argument \emph{statistic} when calling
function \emph{boot}.

\emph{gearyc.boot} is used when performing a non-parametric bootstrap.

\emph{gearyc.pboot} is used when performing a parametric bootstrap.
}


\usage{
gearyc.boot(data, i, ...)
gearyc.pboot(...)
}

\arguments{
\item{data}{A dataframe containing the data, as specified in the 
\bold{DCluster}manpage.}
\item{i}{Permutation generated by the bootstrap procedure}
\item{...}{Aditional arguments passed when performing a bootstrap.}
}

\value{
Both functions return the value of the statistic.
}

\seealso{
DCluster, boot, gearyc, gearyc.stat
}


\examples{
library(boot)
library(spdep)

data(nc.sids)
col.W <- nb2listw(ncCR85.nb, zero.policy=TRUE)

sids<-data.frame(Observed=nc.sids$SID74)
sids<-cbind(sids, Expected=nc.sids$BIR74*sum(nc.sids$SID74)/sum(nc.sids$BIR74))


niter<-100

#Permutation model
gc.perboot<-boot(sids, statistic=gearyc.boot, R=niter, listw=col.W,
	n=length(ncCR85.nb), n1=length(ncCR85.nb)-1, S0=Szero(col.W) )
plot(gc.perboot)#Display results

#Multinomial model
gc.mboot<-boot(sids, statistic=gearyc.pboot, sim="parametric", 
	ran.gen=multinom.sim, R=niter, listw=col.W,
        n=length(ncCR85.nb), n1=length(ncCR85.nb)-1, S0=Szero(col.W) )
plot(gc.mboot)#Display results

#Poisson model
gc.pboot<-boot(sids, statistic=gearyc.pboot, sim="parametric", 
	ran.gen=poisson.sim, R=niter, listw=col.W,
	n=length(ncCR85.nb), n1=length(ncCR85.nb)-1, S0=Szero(col.W) )
plot(gc.pboot)#Display results

#Poisson-Gamma model
gc.pgboot<-boot(sids, statistic=gearyc.pboot, sim="parametric", 
	ran.gen=negbin.sim, R=niter, listw=col.W,
	n=length(ncCR85.nb), n1=length(ncCR85.nb)-1, S0=Szero(col.W) )
plot(gc.pgboot)#Display results

}

\references{
Geary, R. C. (1954). The contiguity ratio and statistical mapping. The Incorporated Statistician 5, 115-145.
}

\keyword{spatial}
