% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_dcpo_results.R
\name{summarize_dcpo_results}
\alias{summarize_dcpo_results}
\title{Extract DCPO Results}
\usage{
summarize_dcpo_results(
  dcpo_input,
  dcpo_output,
  pars = c("theta", "sigma", "alpha", "beta", "delta"),
  probs = c(0.1, 0.9)
)
}
\arguments{
\item{dcpo_input}{the data frame of survey items and marginals generated by \code{DCPOtools::dcpo_setup} previously passed to \code{DCPO::dcpo} to generate the stanfit object passed as \code{dcpo_output}}

\item{dcpo_output}{a stanfit object output by \code{DCPO::dcpo}}

\item{pars}{a character vector of parameter names to be summarized from the \code{DCPO} model: theta (mean public opinion), sigma (polarization in public opinion), alpha (question dispersion), beta (question-cutpoint difficulty), and/or delta (country-specific question bias)}

\item{probs}{a numeric vector of quantiles of interest; the default is c(.1, .9)}
}
\value{
a tibble
}
\description{
\code{summarize_dcpo_results} is a convenience function that produces summary statistics of the main parameters of a DCPO stanfit object along with the relevant identifying information (country, year, question, and cutpoint).
}
\examples{
\dontrun{
out1 <- dcpo(demsup_data,
             chime = FALSE,
             chains = 2,
             iter = 150) # 2 chains/150 iterations for example purposes only; use defaults

theta_results <- summarize_dcpo_results(dcpo_input = demsup_data,
                                        dcpo_output = out1,
                                        pars = "theta")
}

}
