% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBConnection.R
\name{dbExistsTable}
\alias{dbExistsTable}
\title{Does a table exist?}
\usage{
dbExistsTable(conn, name, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{A character string specifying a DBMS table name.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbExistsTable()} returns a logical scalar, \code{TRUE} if the table or view
specified by the \code{name} argument exists, \code{FALSE} otherwise.
This includes temporary tables if supported by the database.

An error is raised
if \code{name} cannot be processed with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}
or if this results in a non-scalar.
}
\description{
Returns if a table given by name exists in the database.
}
\section{Additional arguments}{


TBD: \code{temporary = NA}

This must be provided as named argument.
See the "Specification" section for details on their usage.

}

\section{Specification}{


The \code{name} argument is processed as follows,
to support databases that allow non-syntactic names for their objects:
\itemize{
\item If an unquoted table name as string: \code{dbExistsTable()} will do the
quoting,
perhaps by calling \code{dbQuoteIdentifier(conn, x = name)}
\item If the result of a call to \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}: no more quoting is done
}

For all tables listed by \code{\link[=dbListTables]{dbListTables()}}, \code{dbExistsTable()} returns \code{TRUE}.

}

\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbExistsTable(con, "iris")
dbWriteTable(con, "iris", iris)
dbExistsTable(con, "iris")

dbDisconnect(con)
}
\seealso{
Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExecute}}, \code{\link{dbGetException}},
  \code{\link{dbGetInfo}}, \code{\link{dbGetQuery}},
  \code{\link{dbIsValid}}, \code{\link{dbListFields}},
  \code{\link{dbListResults}}, \code{\link{dbListTables}},
  \code{\link{dbReadTable}}, \code{\link{dbRemoveTable}},
  \code{\link{dbSendQuery}}, \code{\link{dbSendStatement}},
  \code{\link{dbWriteTable}}
}
