% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBConnection.R
\name{dbGetQuery}
\alias{dbGetQuery}
\title{Send query, retrieve results and then clear result set}
\usage{
dbGetQuery(conn, statement, ...)
}
\arguments{
\item{conn}{A \code{\linkS4class{DBIConnection}} object, as produced by
\code{\link{dbConnect}}.}

\item{statement}{a character vector of length 1 containing SQL.}

\item{...}{Other parameters passed on to methods.}
}
\description{
\code{dbGetQuery} comes with a default implementation that calls
\code{\link{dbSendQuery}}, then \code{\link{dbFetch}}, ensuring that
the result is always free-d by \code{\link{dbClearResult}}.
}
\details{
This function is for \code{SELECT} queries only.  Some backends may
support data manipulation statements through this function for compatibility
reasons.  However callers are strongly advised to use
\code{\link{dbExecute}} for data manipulation statements.
}
\section{Implementation notes}{

Subclasses should override this method only if they provide some sort of
performance optimisation.
}
\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars)
dbGetQuery(con, "SELECT * FROM mtcars")

dbDisconnect(con)
}
\seealso{
For updates: \code{\link{dbSendStatement}} and \code{\link{dbExecute}}.

Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExecute}}, \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbIsValid}}, \code{\link{dbListFields}},
  \code{\link{dbListResults}}, \code{\link{dbListTables}},
  \code{\link{dbReadTable}}, \code{\link{dbRemoveTable}},
  \code{\link{dbSendQuery}}, \code{\link{dbSendStatement}}
}

