% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_nonendemic.R
\name{extract_nonendemic}
\alias{extract_nonendemic}
\title{Extracts the information for a non-endemic species from a phylogeny
(specifically `phylo4d`  object from `phylobase` package) and stores it in
in an `island_colonist` class}
\usage{
extract_nonendemic(phylod, species_label)
}
\arguments{
\item{phylod}{A `phylo4d` object from the package `phylobase` containing
phylogenetic and endemicity data for each species.}

\item{species_label}{The tip label of the species of interest.}
}
\value{
An object of `island_colonist` class
}
\description{
Extracts the information for a non-endemic species from a phylogeny
(specifically `phylo4d`  object from `phylobase` package) and stores it in
in an `island_colonist` class
}
\examples{
set.seed(
  1,
  kind = "Mersenne-Twister",
  normal.kind = "Inversion",
  sample.kind = "Rejection"
)
phylo <- ape::rcoal(10)
phylo$tip.label <- c("bird_a", "bird_b", "bird_c", "bird_d", "bird_e",
                     "bird_f", "bird_g", "bird_h", "bird_i", "bird_j")
phylo <- phylobase::phylo4(phylo)
endemicity_status <- sample(
  x = c("not_present", "endemic", "nonendemic"),
  size = length(phylobase::tipLabels(phylo)),
  replace = TRUE,
  prob = c(0.6, 0.2, 0.2)
)
phylod <- phylobase::phylo4d(phylo, as.data.frame(endemicity_status))
extract_nonendemic(phylod = phylod, species_label = "bird_g")
}
