% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PreEst.banded1.R
\name{PreEst.banded1}
\alias{PreEst.banded1}
\title{Bayesian Estimation of a Banded Precision Matrix (Banerjee 2014)}
\usage{
PreEst.banded1(X, upperK = floor(ncol(X)/2), delta = 10,
  logpi = function(k) {     -k^4 }, loss = c("Stein", "Squared"))
}
\arguments{
\item{X}{an \eqn{(n\times p)} data matrix where each row is an observation.}

\item{upperK}{upper bound of bandwidth \eqn{k}.}

\item{delta}{hyperparameter for G-Wishart prior. Default value is 10. It has to be larger than 2.}

\item{logpi}{log of prior distribution for bandwidth \eqn{k}. Default is a function proportional to \eqn{-k^4}.}

\item{loss}{type of loss; either \code{"Stein"} or \code{"Squared"}.}
}
\value{
a named list containing: \describe{
\item{C}{a \eqn{(p\times p)} MAP estimate for precision matrix.}
}
}
\description{
\code{PreEst.banded1} returns a Bayes estimator of the banded precision matrix using G-Wishart prior.
Stein’s loss or squared error loss function is used depending on the “loss” argument in the function.
The bandwidth is set at the mode of marginal posterior for the bandwidth parameter.
}
\examples{
## generate data from multivariate normal with Identity precision.
data = mvtnorm::rmvnorm(100, sigma=diag(10))

## compare different K
out1 <- PreEst.banded1(data, upperK=1)
out2 <- PreEst.banded1(data, upperK=3)
out3 <- PreEst.banded1(data, upperK=5)

## visualize
par(mfrow=c(2,2), pty="s")
image(pracma::flipud(diag(10)),main="Original Precision")
image(pracma::flipud(out1$C), main="banded1::upperK=1")
image(pracma::flipud(out2$C), main="banded1::upperK=3")
image(pracma::flipud(out3$C), main="banded1::upperK=5")

}
\references{
\insertRef{banerjee_posterior_2014}{CovTools}
}
