% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesTest1.R
\name{BayesTest1}
\alias{BayesTest1}
\title{Bayesian One-Sample Tests for Covariance Matrix}
\usage{
BayesTest1(data, Sigma0 = diag(ncol(data)), method = c("mxPBF"), ...)
}
\arguments{
\item{data}{an \eqn{(n\times p)} data matrix where each row is an observation.}

\item{Sigma0}{a \eqn{(p\times p)} given covariance matrix.}

\item{method}{a name of test.}

\item{...}{extra arguments to be passed along for each procedure. See below for details.
\tabular{lll}{
\emph{parameter} \tab \emph{method} \tab \emph{description} \cr
\code{a0} \tab \code{"mxPBF"} \tab hyperparameter (see below for details) \cr
\code{b0} \tab \code{"mxPBF"} \tab hyperparameter (see below for details) \cr
\code{gamma} \tab \code{"mxPBF"} \tab hyperparameter (see below for details)
}}
}
\value{
a named list containing one of followings,
\tabular{lll}{
\emph{element} \tab \emph{method} \tab \emph{description} \cr
\code{log.BF.mat} \tab \code{"mxPBF"} \tab a \eqn{(p\times p)} matrix of pairwise log Bayes factors.
}
}
\description{
Given data, \code{BayesTest1} performs Bayesian version of 1-sample test for Covariance where
the null hypothesis is
\deqn{H_0 : \Sigma_n = \Sigma_0}
where \eqn{\Sigma_n} is the covariance of data model and \eqn{\Sigma_0} is a
hypothesized covariance.
}
\section{mxPBF}{

Let \eqn{X_i} be the \eqn{i}-th column of data matrix. Under the maximum pairwise bayes factor framework, we have following hypothesis,
\deqn{H_0: a_{ij}=0~\mathrm{ and }~\tau_{ij}=1 \quad \mathrm{versus. } \quad  H_1: \mathrm{ not }~ H_0.}
The model is
\deqn{X_i | X_j \sim N_n( a_{ij}X_j, \tau_{ij}^2 I_n )}
and the prior is set, under \eqn{H_1},  as
\deqn{ a_{ij}|\tau_{ij}^2 \sim N(0, \tau_{ij}^2/(\gamma*||X_j||^2))}
\deqn{\tau_{ij}^2 \sim IG(a0, b0).}
}

\examples{
\dontrun{
## generate data from multivariate normal with trivial covariance.
data = matrix(rnorm(100*5), nrow=100)

## run test
BayesTest1(data)                 # default setting
BayesTest1(data, a0=5.0, b0=5.0) # change hyperparameters
}

}
\references{
\insertRef{lee_maximum_2018}{CovTools}
}
