% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bCond.treeCKT.R
\name{bCond.treeCKT}
\alias{bCond.treeCKT}
\title{Construct a binary tree for the modeling the conditional Kendall's tau}
\usage{
bCond.treeCKT(
  XI,
  XJ,
  minCut = 0,
  minProb = 0.01,
  minSize = minProb * nrow(XI),
  nPoints_xJ = 10,
  type.quantile = 7,
  verbose = 2
)
}
\arguments{
\item{XI}{matrix of size n*p of observations of the conditioned variables.}

\item{XJ}{matrix of size n*(d-p) containing observations of the conditioning vector.}

\item{minCut}{minimum difference in probabilities that is necessary to cut.}

\item{minProb}{minimum probability of being in one of the node.}

\item{minSize}{minimum number of observations in each node.
This is an alternative to minProb and has priority over it.}

\item{nPoints_xJ}{number of points in the grid that are considered
when choosing the point for splitting the tree.}

\item{type.quantile}{way of computing the quantiles,
see \code{stats::\link[stats]{quantile}()}.}

\item{verbose}{control the text output of the procedure.
If \code{verbose = 0}, suppress all output.
If \code{verbose = 2}, the progress of the computation
is printed during the computation.}
}
\value{
the estimated tree using the data `XI, XJ`.
}
\description{
This function takes in parameter two matrices of observations:
the first one contains the observations of \code{XI} (the conditioned variables)
and the second on contains the observations of \code{XJ} (the conditioning variables).
The goal of this procedure is to find which of the variables in \code{XJ}
have important influence on the dependence between the components of \code{XI},
(measured by the Kendall's tau).
}
\details{
The object return by this function is a binary tree. Each leaf of this tree
correspond to one event (or, equivalently, one subset of \eqn{R^{dim(XJ)}}),
and the conditional Kendall's tau conditionally to it.
}
\examples{
set.seed(1)
n = 400
XJ = MASS::mvrnorm(n = n, mu = c(3,3), Sigma = rbind(c(1, 0.2), c(0.2, 1)))
XI = matrix(nrow = n, ncol = 2)
high_XJ1 = which(XJ[,1] > 4)
XI[high_XJ1, ]  = MASS::mvrnorm(n = length(high_XJ1), mu = c(10,10),
                                Sigma = rbind(c(1, 0.8), c(0.8, 1)))
XI[-high_XJ1, ] = MASS::mvrnorm(n = n - length(high_XJ1), mu = c(8,8),
                                Sigma = rbind(c(1, -0.2), c(-0.2, 1)))

result = bCond.treeCKT(XI = XI, XJ = XJ, minSize = 50, verbose = 2)
# Plotting the corresponding tree using the "DiagrammeR" package
if (requireNamespace("DiagrammeR", quietly = TRUE)){
  plot(result)
}

# Number of observations in the first two children
print(length(data.tree::GetAttribute(result$children[[1]], "condObs")))
print(length(data.tree::GetAttribute(result$children[[2]], "condObs")))


}
\references{
Derumigny, A., Fermanian, J. D., & Min, A. (2022).
Testing for equality between conditional copulas
given discretized conditioning events.
Canadian Journal of Statistics.
\doi{10.1002/cjs.11742}
}
\seealso{
\code{\link{bCond.simpA.CKT}} for a test of the simplifying assumption
that all these conditional Kendall's tau are equal.

\code{\link{treeCKT2matrixInd}} for converting this tree to a matrix of indicators
of each event. \code{\link{matrixInd2matrixCKT}} for getting the matrix of estimated
conditional Kendall's taus for each event.

\code{\link{CKT.estimate}} for the estimation of
pointwise conditional Kendall's tau,
i.e. assuming a continuous conditioning variable \eqn{Z}.
}
