% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetDC.R
\name{GetDC}
\alias{GetDC}
\title{Occurrence of compound dry-cold events}
\usage{
GetDC(mp,mt,threp,thret)
}
\arguments{
\item{mp}{Precipitation}

\item{mt}{Temperature}

\item{threp}{Threshold of precipitation (e.g., 20th percentile)}

\item{thret}{Threshold of temperature (e.g., 20th percentile)}
}
\value{
The occurrence of compound wet-hot event (0-1 binary variable)
}
\description{
Extract compound dry-cold occurrences based on thresholds of precipitation and temperature. The binary variable of the dry and cold (DC) event can be obtained.
}
\examples{
mp=matrix(rnorm(120,0,1),ncol=1)
mt=matrix(rnorm(120,0,1),ncol=1)
threp=20
thret=20
DC<-GetDC(mp,mt,threp,thret)
}
\references{
Hao, Z. et al (2013). Changes in concurrent monthly precipitation and temperature extremes. Environ. Res. Lett., 8(3): 034014.
}
