% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_colombia_airports.R
\name{get_colombia_airports}
\alias{get_colombia_airports}
\title{Get Colombia's Airports from API Colombia}
\source{
API Colombia: \url{https://api-colombia.com/api/v1/Airport}
}
\usage{
get_colombia_airports()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{id}: Airport identifier (integer)
  \item \code{name}: Airport name (character)
  \item \code{iata_code}: IATA airport code (character)
  \item \code{oaci_code}: ICAO airport code (character)
  \item \code{type}: Airport type (character)
  \item \code{city}: City where airport is located (character)
  \item \code{department}: Department where airport is located (character)
  \item \code{latitude}: Latitude coordinates (numeric)
  \item \code{longitude}: Longitude coordinates (numeric)
}
}
\description{
Retrieves comprehensive information about all Colombian airports from the API Colombia service.
This function fetches data including airport names, codes, types, locations, and geographical coordinates
for all airports across Colombia's departments.
}
\details{
This function sends a GET request to the API Colombia service.
If the API request fails or returns an error status code,
the function returns \code{NULL} with an informative message.
Note: The API returns latitude and longitude values swapped, so this function
corrects the coordinates by swapping them back to their correct positions.
}
\note{
Requires internet connection.
}
\examples{
if (interactive()) {
  get_colombia_airports()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
