% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCohortAttrition.R
\name{plotCohortAttrition}
\alias{plotCohortAttrition}
\title{create a ggplot from the output of summariseLargeScaleCharacteristics.}
\usage{
plotCohortAttrition(
  result,
  show = c("subjects", "records"),
  type = "htmlwidget",
  cohortId = lifecycle::deprecated()
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{show}{Which variables to show in the attrition plot, it can be
'subjects', 'records' or both.}

\item{type}{type of the output, it can either be: 'htmlwidget', 'png', or
'DiagrammeR'.}

\item{cohortId}{deprecated.}
}
\value{
A \code{grViz} visualisation.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(CohortCharacteristics)
library(omopgenerics)
library(dplyr, warn.conflicts = FALSE)
library(clock)

cdm <- mockCohortCharacteristics(numberIndividuals = 1000)

cdm[["cohort1"]] <- cdm[["cohort1"]] |>
  filter(get_year(cohort_start_date) >= 2000) |>
  recordCohortAttrition("Restrict to cohort_start_date >= 2000") |>
  filter(get_year(cohort_end_date) < 2020) |>
  recordCohortAttrition("Restrict to cohort_end_date < 2020") |>
  compute(temporary = FALSE, name = "cohort1")

result <- summariseCohortAttrition(cdm$cohort1)

result |>
  filter(group_level == "cohort_2") |>
  plotCohortAttrition()

}

}
