% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCohortOverlap.R
\name{summariseCohortOverlap}
\alias{summariseCohortOverlap}
\title{Summarise overlap between cohorts in a cohort table}
\usage{
summariseCohortOverlap(cohort, cohortId = NULL, strata = list())
}
\arguments{
\item{cohort}{A cohort table in the cdm.}

\item{cohortId}{A cohort definition id to restrict by. If NULL, all cohorts
will be included.}

\item{strata}{A list of variables to stratify results. These variables
must have been added as additional columns in the cohort table.}
}
\value{
A summary of overlap between cohorts in the cohort table.
}
\description{
Summarise overlap between cohorts in a cohort table
}
\examples{
\donttest{
library(CohortCharacteristics)
cdm <- CohortCharacteristics::mockCohortCharacteristics()
summariseCohortOverlap(cdm$cohort2) |> dplyr::glimpse()
CDMConnector::cdmDisconnect(cdm = cdm)
}
}
