% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FVectorPBmodeloPredi.R
\name{FVectorPBmodeloPredi}
\alias{FVectorPBmodeloPredi}
\title{Obtaining a vector with the covariates of the prediction}
\usage{
FVectorPBmodeloPredi(NumSPBal, DemSPBal, v, MatrizPBmodelo)
}
\arguments{
\item{NumSPBal}{List. The component i of the list has the number of the row of the matrix \code{especie} where the bacteria in the numerator of the principal balance i are placed.}

\item{DemSPBal}{List. The component i of the list has the number of the row of the matrix \code{especie} where the bacteria in the denominator of the principal balance i are placed.}

\item{v}{Vector. Vector with a coda composition. The bacteria ar in the same orden than the matrix \code{especie}}

\item{MatrizPBmodelo}{the matrix that contains the covariates of the model. The first line es equal to 1 for all columns. The other rows contain the value of one SPBal at all time points. The selected principal balance of the row i+1 has at its numerator the bacteria placed in the rows \code{NumSPBal[[i]]} of the "especie". The selected principal balance of the row i+1 has at its denominator the bacteria placed in the rows \code{DemSPBal[[i]]} of the "especie".}
}
\value{
Returns a vector where the first component is a 1 and the following components have the values of the SPBal.  The SPBal in the component i+1  has at its numerator the bacteria placed in the rows \code{Num[[i]]} of the \code{especie}. The SPBal of the component i+1  has at its denominator the bacteria placed in the rows \code{Dem[[i]]} of the \code{especie}.
}
\description{
Calculates a vector with the covariates of the BPBM model in one time point.
}
\examples{

v=c(0.1,0.1,0.2,0.3,0.3)
Num2<-list(3,c(3,5),1,c(3,5,4))
Dem2<-list(5,4,2,c(1,2))
MatrizPBmodelo=rbind(c(1,1,1,1),
                    c(-0.3,0.2,0.5,0.6),
                    c(-0.4,0.3,0.5,0.6),
                    c(0.5,0.3,0.2,0.7),
                    c(-0.2,0.9,0.2,0.1)   )

FVectorPBmodeloPredi(Num2,Dem2,v,MatrizPBmodelo)

}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2022). Bayesian hierarchical compositional models for analysing longitudinal abundance data from microbiome studies. Complexity, 2022.
}
