% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustatis_kmeans.R
\name{clustatis_kmeans}
\alias{clustatis_kmeans}
\title{Compute the CLUSTATIS partitionning algorithm on different blocks of quantitative variables. Can be performed using a multi start strategy or initial partition provided by the user}
\usage{
clustatis_kmeans(Data, Blocks, clust, nstart=100, rho=0, NameBlocks=NULL,
Itermax=30,Graph_groups=TRUE, Graph_weights=FALSE,
 scale=FALSE, print_attempt=FALSE)
}
\arguments{
\item{Data}{data frame or matrix. Correspond to all the blocks of variables merged horizontally}

\item{Blocks}{numerical vector. The number of variables of each block. The sum must be equal to the number of columns of Data}

\item{clust}{numerical vector or integer. Initial partition or number of starting partitions if integer. If numerical vector, the numbers must be 1,2,3,...,number of clusters}

\item{nstart}{integer. Number of starting partitions. Default: 100}

\item{rho}{numerical between 0 and 1. Threshold for the noise cluster. Default:0}

\item{NameBlocks}{string vector. Name of each block. Length must be equal to the length of Blocks vector. If NULL, the names are B1,...Bm. Default: NULL}

\item{Itermax}{numerical. Maximum of iterations by partitionning algorithm. Default: 30}

\item{Graph_groups}{logical. Should each cluster compromise be plotted? Default: TRUE}

\item{Graph_weights}{logical. Should the barplot of the weights in each cluster be plotted? Default: FALSE}

\item{scale}{logical. Should the data variables be scaled? Default: FALSE}

\item{print_attempt}{logical. Print the number of remaining attempts in the multi-start case? Default: FALSE}
}
\value{
a list with:
        \itemize{
         \item group: the clustering partition. If rho>0, some blocks could be in the noise cluster ("K+1")
         \item rho: the threshold for the noise cluster
         \item homogeneity: percentage of homogeneity of the blocks in each cluster and the overall homogeneity
         \item rv_with_compromise: RV coefficient of each block with its cluster compromise
         \item weights: weight associated with each block in its cluster
         \item comp_RV: RV coefficient between the compromises associated with the various clusters
         \item compromise: the W compromise of each cluster
         \item coord: the coordinates of objects of each cluster
         \item inertia: percentage of total variance explained by each axis for each cluster
         \item rv_all_cluster: the RV coefficient between each block and each cluster compromise
         \item criterion: the CLUSTATIS criterion error
         \item param: parameters called
         \item type: parameter passed to other functions
         }
}
\description{
Partitionning algorithm for quantitative variables. Each cluster is associated with a compromise
computed by the STATIS method. Moreover, a noise cluster can be set up.
}
\examples{

 data(smoo)
 NameBlocks=paste0("S",1:24)
 #with multi-start
 cl_km=clustatis_kmeans(Data=smoo,Blocks=rep(2,24),NameBlocks = NameBlocks, clust=3)
 #with an initial partition
 cl=clustatis(Data=smoo,Blocks=rep(2,24),NameBlocks = NameBlocks,
 Graph_dend=FALSE)
 partition=cl$cutree_k$partition3
 cl_km2=clustatis_kmeans(Data=smoo,Blocks=rep(2,24),NameBlocks = NameBlocks,
 clust=partition, Graph_weights=FALSE, Graph_groups=FALSE)

}
\references{
Llobell, F., Cariou, V., Vigneau, E., Labenne, A., & Qannari, E. M. (2018). Analysis and clustering of multiblock datasets by means of the STATIS and CLUSTATIS methods. Application to sensometrics. Food Quality and Preference, in Press.\cr
Llobell, F., Vigneau, E., Qannari, E. M. (2019). Clustering datasets by means of CLUSTATIS with identification of atypical datasets. Application to sensometrics. Food Quality and Preference, 75, 97-104.
}
\seealso{
\code{\link{plot.clustatis}}, \code{\link{clustatis}}, \code{\link{summary.clustatis}}, \code{\link{statis}}
}
\keyword{quantitative}
