% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_Covariate.R
\name{remove_Covariate}
\alias{remove_Covariate}
\title{Remove Covariate from PML models}
\usage{
remove_Covariate(
  PMLParametersSets,
  Name,
  StParmNames = NULL,
  PMLStructures = NULL
)
}
\arguments{
\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{Name}{Character specifying the name of the covariate to be removed.}

\item{StParmNames}{Character or character vector specifying names of
structural parameters from which the covariate will be removed. Can be set
to \code{NULL} or not specified, for such case the covariate will be removed from
all structural parameters.}

\item{PMLStructures}{Character or character vector specifying names of PML
structures from which the covariate will be removed. For the naming
convention of PMLStructures, see Details section of  see details section of
\code{\link[=get_PMLParametersSets]{get_PMLParametersSets()}}.}
}
\value{
An updated list of PML models (\code{PMLModels} class instance) matching
the specified options.
}
\description{
Remove Covariate from PML models
}
\details{
The current functionality does not support removing custom
covariates that are defined within the PML code of custom model spaces.
}
\examples{
PMLParametersSets <- get_PMLParametersSets()

PMLParametersSetsWT <-
 add_Covariate(PMLParametersSets,
               Name = "WT",
               Type = "Continuous",
               State = "Present",
               Direction = "Forward",
               Center = 70)

PMLParametersSetsVonly <-
 remove_Covariate(PMLParametersSets = PMLParametersSetsWT,
               Name = "WT",
               StParmNames = "Cl")

}
\seealso{
\code{\link[=list_Covariates]{list_Covariates()}}

Functions used for Covariate specification: 
\code{\link{Covariate}()},
\code{\link{add_Covariate}()},
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()}
}
\concept{Covariates}
